@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.DedicatedHostGroupArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the dedicated host group that the dedicated hosts should be assigned to. Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create or update a dedicated host group with Ultra SSD support.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHostGroup = new AzureNative.Compute.DedicatedHostGroup("dedicatedHostGroup", new()
 *     {
 *         AdditionalCapabilities = new AzureNative.Compute.Inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs
 *         {
 *             UltraSSDEnabled = true,
 *         },
 *         HostGroupName = "myDedicatedHostGroup",
 *         Location = "westus",
 *         PlatformFaultDomainCount = 3,
 *         ResourceGroupName = "myResourceGroup",
 *         SupportAutomaticPlacement = true,
 *         Tags =
 *         {
 *             { "department", "finance" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDedicatedHostGroup(ctx, "dedicatedHostGroup", &compute.DedicatedHostGroupArgs{
 * 			AdditionalCapabilities: &compute.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs{
 * 				UltraSSDEnabled: pulumi.Bool(true),
 * 			},
 * 			HostGroupName:             pulumi.String("myDedicatedHostGroup"),
 * 			Location:                  pulumi.String("westus"),
 * 			PlatformFaultDomainCount:  pulumi.Int(3),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 			SupportAutomaticPlacement: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("finance"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DedicatedHostGroup;
 * import com.pulumi.azurenative.compute.DedicatedHostGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHostGroup = new DedicatedHostGroup("dedicatedHostGroup", DedicatedHostGroupArgs.builder()
 *             .additionalCapabilities(Map.of("ultraSSDEnabled", true))
 *             .hostGroupName("myDedicatedHostGroup")
 *             .location("westus")
 *             .platformFaultDomainCount(3)
 *             .resourceGroupName("myResourceGroup")
 *             .supportAutomaticPlacement(true)
 *             .tags(Map.of("department", "finance"))
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a dedicated host group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHostGroup = new AzureNative.Compute.DedicatedHostGroup("dedicatedHostGroup", new()
 *     {
 *         HostGroupName = "myDedicatedHostGroup",
 *         Location = "westus",
 *         PlatformFaultDomainCount = 3,
 *         ResourceGroupName = "myResourceGroup",
 *         SupportAutomaticPlacement = true,
 *         Tags =
 *         {
 *             { "department", "finance" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDedicatedHostGroup(ctx, "dedicatedHostGroup", &compute.DedicatedHostGroupArgs{
 * 			HostGroupName:             pulumi.String("myDedicatedHostGroup"),
 * 			Location:                  pulumi.String("westus"),
 * 			PlatformFaultDomainCount:  pulumi.Int(3),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 			SupportAutomaticPlacement: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("finance"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DedicatedHostGroup;
 * import com.pulumi.azurenative.compute.DedicatedHostGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHostGroup = new DedicatedHostGroup("dedicatedHostGroup", DedicatedHostGroupArgs.builder()
 *             .hostGroupName("myDedicatedHostGroup")
 *             .location("westus")
 *             .platformFaultDomainCount(3)
 *             .resourceGroupName("myResourceGroup")
 *             .supportAutomaticPlacement(true)
 *             .tags(Map.of("department", "finance"))
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DedicatedHostGroup myDedicatedHostGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}
 * ```
 * @property additionalCapabilities Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
 * @property hostGroupName The name of the dedicated host group.
 * @property location Resource location
 * @property platformFaultDomainCount Number of fault domains that the host group can span.
 * @property resourceGroupName The name of the resource group.
 * @property supportAutomaticPlacement Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated host group. Automatic placement means resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
 * @property tags Resource tags
 * @property zones Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
 */
public data class DedicatedHostGroupArgs(
    public val additionalCapabilities: Output<DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs>? =
        null,
    public val hostGroupName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val platformFaultDomainCount: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val supportAutomaticPlacement: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.DedicatedHostGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.DedicatedHostGroupArgs =
        com.pulumi.azurenative.compute.DedicatedHostGroupArgs.builder()
            .additionalCapabilities(
                additionalCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hostGroupName(hostGroupName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .platformFaultDomainCount(platformFaultDomainCount?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .supportAutomaticPlacement(supportAutomaticPlacement?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DedicatedHostGroupArgs].
 */
@PulumiTagMarker
public class DedicatedHostGroupArgsBuilder internal constructor() {
    private var additionalCapabilities:
        Output<DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs>? = null

    private var hostGroupName: Output<String>? = null

    private var location: Output<String>? = null

    private var platformFaultDomainCount: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var supportAutomaticPlacement: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
     */
    @JvmName("omhgflkvvtgrugyn")
    public suspend
    fun additionalCapabilities(`value`: Output<DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs>) {
        this.additionalCapabilities = value
    }

    /**
     * @param value The name of the dedicated host group.
     */
    @JvmName("fujpsfaqevwhioxm")
    public suspend fun hostGroupName(`value`: Output<String>) {
        this.hostGroupName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("cionlqgqjgqnvrsa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Number of fault domains that the host group can span.
     */
    @JvmName("meydgettflrhaags")
    public suspend fun platformFaultDomainCount(`value`: Output<Int>) {
        this.platformFaultDomainCount = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cfusrkaetfurydrd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated host group. Automatic placement means resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
     */
    @JvmName("ygyngprodbgxysgx")
    public suspend fun supportAutomaticPlacement(`value`: Output<Boolean>) {
        this.supportAutomaticPlacement = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("glbanewstdgsrfbl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
     */
    @JvmName("kpeulyolmixfhulh")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("cvisrfrbqweccdvq")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
     */
    @JvmName("lslqqcockiroajvy")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
     */
    @JvmName("dvobmrndwsuvdrrl")
    public suspend
    fun additionalCapabilities(`value`: DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCapabilities = mapped
    }

    /**
     * @param argument Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
     */
    @JvmName("evhlvcderfykrvnx")
    public suspend
    fun additionalCapabilities(argument: suspend DedicatedHostGroupPropertiesAdditionalCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = DedicatedHostGroupPropertiesAdditionalCapabilitiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.additionalCapabilities = mapped
    }

    /**
     * @param value The name of the dedicated host group.
     */
    @JvmName("frnlkkqjvwupfsuo")
    public suspend fun hostGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroupName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("wioeahhsrrosnupn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Number of fault domains that the host group can span.
     */
    @JvmName("kmywfutnxcjedjyh")
    public suspend fun platformFaultDomainCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformFaultDomainCount = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vyiuvrwyrjuhmdwo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated host group. Automatic placement means resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
     */
    @JvmName("mdavxnnstosplylk")
    public suspend fun supportAutomaticPlacement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportAutomaticPlacement = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("otfclhxfnqcruvid")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("nmdbcwdvknaejtnj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
     */
    @JvmName("wswaoodcvlstipxf")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
     */
    @JvmName("xpjbqmwjpjyryoyp")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): DedicatedHostGroupArgs = DedicatedHostGroupArgs(
        additionalCapabilities = additionalCapabilities,
        hostGroupName = hostGroupName,
        location = location,
        platformFaultDomainCount = platformFaultDomainCount,
        resourceGroupName = resourceGroupName,
        supportAutomaticPlacement = supportAutomaticPlacement,
        tags = tags,
        zones = zones,
    )
}
