@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin

/**
 * Builder for [DiskAccess].
 */
@PulumiTagMarker
public class DiskAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskAccessArgs = DiskAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskAccessArgsBuilder.() -> Unit) {
        val builder = DiskAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DiskAccess {
        val builtJavaResource = com.pulumi.azurenative.compute.DiskAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DiskAccess(builtJavaResource)
    }
}

/**
 * disk access resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Create a disk access resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskAccess = new AzureNative.Compute.DiskAccess("diskAccess", new()
 *     {
 *         DiskAccessName = "myDiskAccess",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDiskAccess(ctx, "diskAccess", &compute.DiskAccessArgs{
 * 			DiskAccessName:    pulumi.String("myDiskAccess"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DiskAccess;
 * import com.pulumi.azurenative.compute.DiskAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskAccess = new DiskAccess("diskAccess", DiskAccessArgs.builder()
 *             .diskAccessName("myDiskAccess")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DiskAccess myDiskAccess /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}
 * ```
 */
public class DiskAccess internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.DiskAccess,
) : KotlinCustomResource(javaResource, DiskAccessMapper) {
    /**
     * The extended location where the disk access will be created. Extended location cannot be changed.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A readonly collection of private endpoint connections created on the disk. Currently only one endpoint connection is supported.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The disk access resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The time when the disk access was created.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DiskAccessMapper : ResourceMapper<DiskAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.DiskAccess::class == javaResource::class

    override fun map(javaResource: Resource): DiskAccess = DiskAccess(
        javaResource as
            com.pulumi.azurenative.compute.DiskAccess,
    )
}

/**
 * @see [DiskAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiskAccess].
 */
public suspend fun diskAccess(name: String, block: suspend DiskAccessResourceBuilder.() -> Unit):
    DiskAccess {
    val builder = DiskAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiskAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diskAccess(name: String): DiskAccess {
    val builder = DiskAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
