@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Approve a Private Endpoint Connection under a disk access resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskAccessAPrivateEndpointConnection = new AzureNative.Compute.DiskAccessAPrivateEndpointConnection("diskAccessAPrivateEndpointConnection", new()
 *     {
 *         DiskAccessName = "myDiskAccess",
 *         PrivateEndpointConnectionName = "myPrivateEndpointConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.Compute.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Approving myPrivateEndpointConnection",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDiskAccessAPrivateEndpointConnection(ctx, "diskAccessAPrivateEndpointConnection", &compute.DiskAccessAPrivateEndpointConnectionArgs{
 * 			DiskAccessName:                pulumi.String("myDiskAccess"),
 * 			PrivateEndpointConnectionName: pulumi.String("myPrivateEndpointConnection"),
 * 			PrivateLinkServiceConnectionState: &compute.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Approving myPrivateEndpointConnection"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnection;
 * import com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskAccessAPrivateEndpointConnection = new DiskAccessAPrivateEndpointConnection("diskAccessAPrivateEndpointConnection", DiskAccessAPrivateEndpointConnectionArgs.builder()
 *             .diskAccessName("myDiskAccess")
 *             .privateEndpointConnectionName("myPrivateEndpointConnection")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Approving myPrivateEndpointConnection"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DiskAccessAPrivateEndpointConnection myPrivateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property diskAccessName The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between DiskAccess and Virtual Network.
 * @property resourceGroupName The name of the resource group.
 */
public data class DiskAccessAPrivateEndpointConnectionArgs(
    public val diskAccessName: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnectionArgs.builder()
            .diskAccessName(diskAccessName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskAccessAPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class DiskAccessAPrivateEndpointConnectionArgsBuilder internal constructor() {
    private var diskAccessName: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("hbupiavvxytqyepp")
    public suspend fun diskAccessName(`value`: Output<String>) {
        this.diskAccessName = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("qbjraugoqgobwfaj")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between DiskAccess and Virtual Network.
     */
    @JvmName("vjwflgqxmvomsdkm")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("blinkaykeyqtfnqx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the disk access resource that is being created. The name can't be changed after the disk encryption set is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("xeircitlcqrgdxqj")
    public suspend fun diskAccessName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskAccessName = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("kcbhqkqpvyllnyiy")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between DiskAccess and Virtual Network.
     */
    @JvmName("ctjwtddryjpufpit")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between DiskAccess and Virtual Network.
     */
    @JvmName("ythqjmkdgqulmgbc")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eybtrhvgaxplxlqg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DiskAccessAPrivateEndpointConnectionArgs =
        DiskAccessAPrivateEndpointConnectionArgs(
            diskAccessName = diskAccessName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
        )
}
