@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.GalleryArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.SharingProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SharingProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SoftDeletePolicyArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SoftDeletePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the Shared Image Gallery that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2022-08-03.
 * ## Example Usage
 * ### Create a community gallery.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SharingProfile = new AzureNative.Compute.Inputs.SharingProfileArgs
 *         {
 *             CommunityGalleryInfo = new AzureNative.Compute.Inputs.CommunityGalleryInfoArgs
 *             {
 *                 Eula = "eula",
 *                 PublicNamePrefix = "PirPublic",
 *                 PublisherContact = "pir@microsoft.com",
 *                 PublisherUri = "uri",
 *             },
 *             Permissions = "Community",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SharingProfile: compute.SharingProfileResponse{
 * 				CommunityGalleryInfo: &compute.CommunityGalleryInfoArgs{
 * 					Eula:             pulumi.String("eula"),
 * 					PublicNamePrefix: pulumi.String("PirPublic"),
 * 					PublisherContact: pulumi.String("pir@microsoft.com"),
 * 					PublisherUri:     pulumi.String("uri"),
 * 				},
 * 				Permissions: pulumi.String("Community"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sharingProfile(Map.ofEntries(
 *                 Map.entry("communityGalleryInfo", Map.ofEntries(
 *                     Map.entry("eula", "eula"),
 *                     Map.entry("publicNamePrefix", "PirPublic"),
 *                     Map.entry("publisherContact", "pir@microsoft.com"),
 *                     Map.entry("publisherUri", "uri")
 *                 )),
 *                 Map.entry("permissions", "Community")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery with sharing profile.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SharingProfile = new AzureNative.Compute.Inputs.SharingProfileArgs
 *         {
 *             Permissions = "Groups",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SharingProfile: &compute.SharingProfileArgs{
 * 				Permissions: pulumi.String("Groups"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sharingProfile(Map.of("permissions", "Groups"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery with soft deletion enabled.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SoftDeletePolicy = new AzureNative.Compute.Inputs.SoftDeletePolicyArgs
 *         {
 *             IsSoftDeleteEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SoftDeletePolicy: &compute.SoftDeletePolicyArgs{
 * 				IsSoftDeleteEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .softDeletePolicy(Map.of("isSoftDeleteEnabled", true))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Gallery myGalleryName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}
 * ```
 * @property description The description of this Shared Image Gallery resource. This property is updatable.
 * @property galleryName The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with dots and periods allowed in the middle. The maximum length is 80 characters.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group.
 * @property sharingProfile Profile for gallery sharing to subscription or tenant
 * @property softDeletePolicy Contains information about the soft deletion policy of the gallery.
 * @property tags Resource tags
 */
public data class GalleryArgs(
    public val description: Output<String>? = null,
    public val galleryName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sharingProfile: Output<SharingProfileArgs>? = null,
    public val softDeletePolicy: Output<SoftDeletePolicyArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.GalleryArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.GalleryArgs =
        com.pulumi.azurenative.compute.GalleryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .galleryName(galleryName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sharingProfile(sharingProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .softDeletePolicy(softDeletePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GalleryArgs].
 */
@PulumiTagMarker
public class GalleryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var galleryName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sharingProfile: Output<SharingProfileArgs>? = null

    private var softDeletePolicy: Output<SoftDeletePolicyArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of this Shared Image Gallery resource. This property is updatable.
     */
    @JvmName("wjqpdfhmownkdkeg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with dots and periods allowed in the middle. The maximum length is 80 characters.
     */
    @JvmName("ahpjviwolywpyuer")
    public suspend fun galleryName(`value`: Output<String>) {
        this.galleryName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("iyfielvlcbvrqauu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("egonmbugirrsijfp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Profile for gallery sharing to subscription or tenant
     */
    @JvmName("gwadjtnhlfmpcrfg")
    public suspend fun sharingProfile(`value`: Output<SharingProfileArgs>) {
        this.sharingProfile = value
    }

    /**
     * @param value Contains information about the soft deletion policy of the gallery.
     */
    @JvmName("pceiydwiddcgsdto")
    public suspend fun softDeletePolicy(`value`: Output<SoftDeletePolicyArgs>) {
        this.softDeletePolicy = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("mymmtlbhqsathxxm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of this Shared Image Gallery resource. This property is updatable.
     */
    @JvmName("pejupdsogidstbtu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Shared Image Gallery. The allowed characters are alphabets and numbers with dots and periods allowed in the middle. The maximum length is 80 characters.
     */
    @JvmName("gsvvkobuwpyolfre")
    public suspend fun galleryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("npykxrfshphvpimh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jgmucexmbyxdjmab")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Profile for gallery sharing to subscription or tenant
     */
    @JvmName("fiieaxlbxmnlxvgp")
    public suspend fun sharingProfile(`value`: SharingProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharingProfile = mapped
    }

    /**
     * @param argument Profile for gallery sharing to subscription or tenant
     */
    @JvmName("fijtxmonukbjxjpn")
    public suspend fun sharingProfile(argument: suspend SharingProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SharingProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sharingProfile = mapped
    }

    /**
     * @param value Contains information about the soft deletion policy of the gallery.
     */
    @JvmName("nppsawrdwixlbicr")
    public suspend fun softDeletePolicy(`value`: SoftDeletePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeletePolicy = mapped
    }

    /**
     * @param argument Contains information about the soft deletion policy of the gallery.
     */
    @JvmName("njvevwxjforhlocq")
    public suspend fun softDeletePolicy(argument: suspend SoftDeletePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = SoftDeletePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.softDeletePolicy = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("usrunhrafpeefkmk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("demawelwybydvkck")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GalleryArgs = GalleryArgs(
        description = description,
        galleryName = galleryName,
        location = location,
        resourceGroupName = resourceGroupName,
        sharingProfile = sharingProfile,
        softDeletePolicy = softDeletePolicy,
        tags = tags,
    )
}
