@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.DisallowedResponse
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageFeatureResponse
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageIdentifierResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ImagePurchasePlanResponse
import com.pulumi.azurenative.compute.kotlin.outputs.RecommendedMachineConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.DisallowedResponse.Companion.toKotlin as disallowedResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageFeatureResponse.Companion.toKotlin as galleryImageFeatureResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryImageIdentifierResponse.Companion.toKotlin as galleryImageIdentifierResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ImagePurchasePlanResponse.Companion.toKotlin as imagePurchasePlanResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.RecommendedMachineConfigurationResponse.Companion.toKotlin as recommendedMachineConfigurationResponseToKotlin

/**
 * Builder for [GalleryImage].
 */
@PulumiTagMarker
public class GalleryImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GalleryImageArgs = GalleryImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GalleryImageArgsBuilder.() -> Unit) {
        val builder = GalleryImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GalleryImage {
        val builtJavaResource = com.pulumi.azurenative.compute.GalleryImage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GalleryImage(builtJavaResource)
    }
}

/**
 * Specifies information about the gallery image definition that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2022-08-03.
 * ## Example Usage
 * ### Create or update a simple gallery image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImage = new AzureNative.Compute.GalleryImage("galleryImage", new()
 *     {
 *         GalleryImageName = "myGalleryImageName",
 *         GalleryName = "myGalleryName",
 *         HyperVGeneration = "V1",
 *         Identifier = new AzureNative.Compute.Inputs.GalleryImageIdentifierArgs
 *         {
 *             Offer = "myOfferName",
 *             Publisher = "myPublisherName",
 *             Sku = "mySkuName",
 *         },
 *         Location = "West US",
 *         OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *         OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGalleryImage(ctx, "galleryImage", &compute.GalleryImageArgs{
 * 			GalleryImageName: pulumi.String("myGalleryImageName"),
 * 			GalleryName:      pulumi.String("myGalleryName"),
 * 			HyperVGeneration: pulumi.String("V1"),
 * 			Identifier: &compute.GalleryImageIdentifierArgs{
 * 				Offer:     pulumi.String("myOfferName"),
 * 				Publisher: pulumi.String("myPublisherName"),
 * 				Sku:       pulumi.String("mySkuName"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			OsState:           compute.OperatingSystemStateTypesGeneralized,
 * 			OsType:            compute.OperatingSystemTypesWindows,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryImage;
 * import com.pulumi.azurenative.compute.GalleryImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImage = new GalleryImage("galleryImage", GalleryImageArgs.builder()
 *             .galleryImageName("myGalleryImageName")
 *             .galleryName("myGalleryName")
 *             .hyperVGeneration("V1")
 *             .identifier(Map.ofEntries(
 *                 Map.entry("offer", "myOfferName"),
 *                 Map.entry("publisher", "myPublisherName"),
 *                 Map.entry("sku", "mySkuName")
 *             ))
 *             .location("West US")
 *             .osState("Generalized")
 *             .osType("Windows")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryImage myGalleryImageName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}
 * ```
 */
public class GalleryImage internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.GalleryImage,
) : KotlinCustomResource(javaResource, GalleryImageMapper) {
    /**
     * The architecture of the image. Applicable to OS disks only.
     */
    public val architecture: Output<String>?
        get() = javaResource.architecture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of this gallery image definition resource. This property is updatable.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the disallowed disk types.
     */
    public val disallowed: Output<DisallowedResponse>?
        get() = javaResource.disallowed().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    disallowedResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The end of life date of the gallery image definition. This property can be used for decommissioning purposes. This property is updatable.
     */
    public val endOfLifeDate: Output<String>?
        get() = javaResource.endOfLifeDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Eula agreement for the gallery image definition.
     */
    public val eula: Output<String>?
        get() = javaResource.eula().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of gallery image features.
     */
    public val features: Output<List<GalleryImageFeatureResponse>>?
        get() = javaResource.features().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> galleryImageFeatureResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    public val hyperVGeneration: Output<String>?
        get() = javaResource.hyperVGeneration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the gallery image definition identifier.
     */
    public val identifier: Output<GalleryImageIdentifierResponse>
        get() = javaResource.identifier().applyValue({ args0 ->
            args0.let({ args0 ->
                galleryImageIdentifierResponseToKotlin(args0)
            })
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * This property allows the user to specify whether the virtual machines created under this image are 'Generalized' or 'Specialized'.
     */
    public val osState: Output<String>
        get() = javaResource.osState().applyValue({ args0 -> args0 })

    /**
     * This property allows you to specify the type of the OS that is included in the disk when creating a VM from a managed image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
     */
    public val osType: Output<String>
        get() = javaResource.osType().applyValue({ args0 -> args0 })

    /**
     * The privacy statement uri.
     */
    public val privacyStatementUri: Output<String>?
        get() = javaResource.privacyStatementUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Describes the gallery image definition purchase plan. This is used by marketplace images.
     */
    public val purchasePlan: Output<ImagePurchasePlanResponse>?
        get() = javaResource.purchasePlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    imagePurchasePlanResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
     */
    public val recommended: Output<RecommendedMachineConfigurationResponse>?
        get() = javaResource.recommended().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    recommendedMachineConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The release note uri.
     */
    public val releaseNoteUri: Output<String>?
        get() = javaResource.releaseNoteUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GalleryImageMapper : ResourceMapper<GalleryImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.GalleryImage::class == javaResource::class

    override fun map(javaResource: Resource): GalleryImage = GalleryImage(
        javaResource as
            com.pulumi.azurenative.compute.GalleryImage,
    )
}

/**
 * @see [GalleryImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GalleryImage].
 */
public suspend fun galleryImage(
    name: String,
    block: suspend GalleryImageResourceBuilder.() -> Unit,
): GalleryImage {
    val builder = GalleryImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GalleryImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun galleryImage(name: String): GalleryImage {
    val builder = GalleryImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
