@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.RestorePointCollectionArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.RestorePointCollectionSourcePropertiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.RestorePointCollectionSourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Create or update Restore Point collection parameters.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create or update a restore point collection for cross region copy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePointCollection = new AzureNative.Compute.RestorePointCollection("restorePointCollection", new()
 *     {
 *         Location = "norwayeast",
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "myRpc",
 *         Source = new AzureNative.Compute.Inputs.RestorePointCollectionSourcePropertiesArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName",
 *         },
 *         Tags =
 *         {
 *             { "myTag1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePointCollection(ctx, "restorePointCollection", &compute.RestorePointCollectionArgs{
 * 			Location:                   pulumi.String("norwayeast"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("myRpc"),
 * 			Source: &compute.RestorePointCollectionSourcePropertiesArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"myTag1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePointCollection;
 * import com.pulumi.azurenative.compute.RestorePointCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePointCollection = new RestorePointCollection("restorePointCollection", RestorePointCollectionArgs.builder()
 *             .location("norwayeast")
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("myRpc")
 *             .source(Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/restorePointCollections/sourceRpcName"))
 *             .tags(Map.of("myTag1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a restore point collection.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var restorePointCollection = new AzureNative.Compute.RestorePointCollection("restorePointCollection", new()
 *     {
 *         Location = "norwayeast",
 *         ResourceGroupName = "myResourceGroup",
 *         RestorePointCollectionName = "myRpc",
 *         Source = new AzureNative.Compute.Inputs.RestorePointCollectionSourcePropertiesArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM",
 *         },
 *         Tags =
 *         {
 *             { "myTag1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewRestorePointCollection(ctx, "restorePointCollection", &compute.RestorePointCollectionArgs{
 * 			Location:                   pulumi.String("norwayeast"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			RestorePointCollectionName: pulumi.String("myRpc"),
 * 			Source: &compute.RestorePointCollectionSourcePropertiesArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"myTag1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.RestorePointCollection;
 * import com.pulumi.azurenative.compute.RestorePointCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var restorePointCollection = new RestorePointCollection("restorePointCollection", RestorePointCollectionArgs.builder()
 *             .location("norwayeast")
 *             .resourceGroupName("myResourceGroup")
 *             .restorePointCollectionName("myRpc")
 *             .source(Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM"))
 *             .tags(Map.of("myTag1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:RestorePointCollection myRpc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}
 * ```
 * @property location Resource location
 * @property resourceGroupName The name of the resource group.
 * @property restorePointCollectionName The name of the restore point collection.
 * @property source The properties of the source resource that this restore point collection is created from.
 * @property tags Resource tags
 */
public data class RestorePointCollectionArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restorePointCollectionName: Output<String>? = null,
    public val source: Output<RestorePointCollectionSourcePropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.RestorePointCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.RestorePointCollectionArgs =
        com.pulumi.azurenative.compute.RestorePointCollectionArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restorePointCollectionName(restorePointCollectionName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RestorePointCollectionArgs].
 */
@PulumiTagMarker
public class RestorePointCollectionArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var restorePointCollectionName: Output<String>? = null

    private var source: Output<RestorePointCollectionSourcePropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource location
     */
    @JvmName("vfmlseihpuhytjsm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ixudgctnamhxqqtx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the restore point collection.
     */
    @JvmName("mpmfbfrhlpmkiraq")
    public suspend fun restorePointCollectionName(`value`: Output<String>) {
        this.restorePointCollectionName = value
    }

    /**
     * @param value The properties of the source resource that this restore point collection is created from.
     */
    @JvmName("tloochrcunrtkdix")
    public suspend fun source(`value`: Output<RestorePointCollectionSourcePropertiesArgs>) {
        this.source = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("mkldvlrqmgiycqeq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("wdpgpxahkhtnjdhb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jlsnojubgqfshsgg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the restore point collection.
     */
    @JvmName("qslvnwspigqqshml")
    public suspend fun restorePointCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePointCollectionName = mapped
    }

    /**
     * @param value The properties of the source resource that this restore point collection is created from.
     */
    @JvmName("iqylfeurcehnqucs")
    public suspend fun source(`value`: RestorePointCollectionSourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The properties of the source resource that this restore point collection is created from.
     */
    @JvmName("tsnuaonawokwdkxj")
    public suspend
    fun source(argument: suspend RestorePointCollectionSourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RestorePointCollectionSourcePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qrdsjsaapiparlji")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("seaftppxkkcqdeul")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RestorePointCollectionArgs = RestorePointCollectionArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        restorePointCollectionName = restorePointCollectionName,
        source = source,
        tags = tags,
    )
}
