@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.SshPublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the SSH public key.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create a new SSH public key resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sshPublicKey = new AzureNative.Compute.SshPublicKey("sshPublicKey", new()
 *     {
 *         Location = "westus",
 *         PublicKey = "{ssh-rsa public key}",
 *         ResourceGroupName = "myResourceGroup",
 *         SshPublicKeyName = "mySshPublicKeyName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSshPublicKey(ctx, "sshPublicKey", &compute.SshPublicKeyArgs{
 * 			Location:          pulumi.String("westus"),
 * 			PublicKey:         pulumi.String("{ssh-rsa public key}"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SshPublicKeyName:  pulumi.String("mySshPublicKeyName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.SshPublicKey;
 * import com.pulumi.azurenative.compute.SshPublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sshPublicKey = new SshPublicKey("sshPublicKey", SshPublicKeyArgs.builder()
 *             .location("westus")
 *             .publicKey("{ssh-rsa public key}")
 *             .resourceGroupName("myResourceGroup")
 *             .sshPublicKeyName("mySshPublicKeyName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:SshPublicKey mySshPublicKeyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}
 * ```
 * @property location Resource location
 * @property publicKey SSH public key used to authenticate to a virtual machine through ssh. If this property is not initially provided when the resource is created, the publicKey property will be populated when generateKeyPair is called. If the public key is provided upon resource creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
 * @property resourceGroupName The name of the resource group.
 * @property sshPublicKeyName The name of the SSH public key.
 * @property tags Resource tags
 */
public data class SshPublicKeyArgs(
    public val location: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sshPublicKeyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.SshPublicKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.SshPublicKeyArgs =
        com.pulumi.azurenative.compute.SshPublicKeyArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sshPublicKeyName(sshPublicKeyName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SshPublicKeyArgs].
 */
@PulumiTagMarker
public class SshPublicKeyArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sshPublicKeyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource location
     */
    @JvmName("gbcxttitqkbnvine")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value SSH public key used to authenticate to a virtual machine through ssh. If this property is not initially provided when the resource is created, the publicKey property will be populated when generateKeyPair is called. If the public key is provided upon resource creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
     */
    @JvmName("rootilffobyioqxn")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vbewjodrupdukatm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the SSH public key.
     */
    @JvmName("tnbyblgmraeooifq")
    public suspend fun sshPublicKeyName(`value`: Output<String>) {
        this.sshPublicKeyName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("sidfjqhyhkfqreux")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("gayxdvpowefhrsly")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value SSH public key used to authenticate to a virtual machine through ssh. If this property is not initially provided when the resource is created, the publicKey property will be populated when generateKeyPair is called. If the public key is provided upon resource creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
     */
    @JvmName("qaktgpafmxlevsqn")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ppcyrtfjqmqwwbdq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SSH public key.
     */
    @JvmName("hvjfpbccyjfyaxtx")
    public suspend fun sshPublicKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKeyName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ujhfqjdnhaxbndod")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("vamieabdrvxgmnhu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SshPublicKeyArgs = SshPublicKeyArgs(
        location = location,
        publicKey = publicKey,
        resourceGroupName = resourceGroupName,
        sshPublicKeyName = sshPublicKeyName,
        tags = tags,
    )
}
