@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.KeyVaultSecretReferenceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.KeyVaultSecretReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine Scale Set Extension.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-11-01, 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualMachineScaleSetExtension_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetExtension = new AzureNative.Compute.VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         EnableAutomaticUpgrade = true,
 *         ForceUpdateTag = "aaaaaaaaa",
 *         Name = "{extension-name}",
 *         ProtectedSettings = null,
 *         ProvisionAfterExtensions = new[]
 *         {
 *             "aa",
 *         },
 *         Publisher = "{extension-Publisher}",
 *         ResourceGroupName = "rgcompute",
 *         Settings = null,
 *         SuppressFailures = true,
 *         Type = "{extension-Type}",
 *         TypeHandlerVersion = "{handler-version}",
 *         VmScaleSetName = "aaaaaaa",
 *         VmssExtensionName = "aaaaaaaaaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetExtension(ctx, "virtualMachineScaleSetExtension", &compute.VirtualMachineScaleSetExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			EnableAutomaticUpgrade:  pulumi.Bool(true),
 * 			ForceUpdateTag:          pulumi.String("aaaaaaaaa"),
 * 			Name:                    pulumi.String("{extension-name}"),
 * 			ProtectedSettings:       nil,
 * 			ProvisionAfterExtensions: pulumi.StringArray{
 * 				pulumi.String("aa"),
 * 			},
 * 			Publisher:          pulumi.String("{extension-Publisher}"),
 * 			ResourceGroupName:  pulumi.String("rgcompute"),
 * 			Settings:           nil,
 * 			SuppressFailures:   pulumi.Bool(true),
 * 			Type:               pulumi.String("{extension-Type}"),
 * 			TypeHandlerVersion: pulumi.String("{handler-version}"),
 * 			VmScaleSetName:     pulumi.String("aaaaaaa"),
 * 			VmssExtensionName:  pulumi.String("aaaaaaaaaaaaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetExtension = new VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", VirtualMachineScaleSetExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .enableAutomaticUpgrade(true)
 *             .forceUpdateTag("aaaaaaaaa")
 *             .name("{extension-name}")
 *             .protectedSettings()
 *             .provisionAfterExtensions("aa")
 *             .publisher("{extension-Publisher}")
 *             .resourceGroupName("rgcompute")
 *             .settings()
 *             .suppressFailures(true)
 *             .type("{extension-Type}")
 *             .typeHandlerVersion("{handler-version}")
 *             .vmScaleSetName("aaaaaaa")
 *             .vmssExtensionName("aaaaaaaaaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ### VirtualMachineScaleSetExtension_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetExtension = new AzureNative.Compute.VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", new()
 *     {
 *         ResourceGroupName = "rgcompute",
 *         VmScaleSetName = "aaaaaaaaaaa",
 *         VmssExtensionName = "aaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetExtension(ctx, "virtualMachineScaleSetExtension", &compute.VirtualMachineScaleSetExtensionArgs{
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			VmScaleSetName:    pulumi.String("aaaaaaaaaaa"),
 * 			VmssExtensionName: pulumi.String("aaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetExtension = new VirtualMachineScaleSetExtension("virtualMachineScaleSetExtension", VirtualMachineScaleSetExtensionArgs.builder()
 *             .resourceGroupName("rgcompute")
 *             .vmScaleSetName("aaaaaaaaaaa")
 *             .vmssExtensionName("aaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSetExtension {extension-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensions/{vmssExtensionName}
 * ```
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
 * @property name The name of the extension.
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property protectedSettingsFromKeyVault The extensions protected settings that are passed by reference, and consumed from key vault
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property publisher The name of the extension handler publisher.
 * @property resourceGroupName The name of the resource group.
 * @property settings Json formatted public settings for the extension.
 * @property suppressFailures Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 * @property vmScaleSetName The name of the VM scale set where the extension should be create or updated.
 * @property vmssExtensionName The name of the VM scale set extension.
 */
public data class VirtualMachineScaleSetExtensionArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null,
    public val provisionAfterExtensions: Output<List<String>>? = null,
    public val publisher: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settings: Output<Any>? = null,
    public val suppressFailures: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
    public val vmScaleSetName: Output<String>? = null,
    public val vmssExtensionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetExtensionArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .protectedSettingsFromKeyVault(
                protectedSettingsFromKeyVault?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisionAfterExtensions(
                provisionAfterExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .suppressFailures(suppressFailures?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName?.applyValue({ args0 -> args0 }))
            .vmssExtensionName(vmssExtensionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetExtensionArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetExtensionArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var forceUpdateTag: Output<String>? = null

    private var name: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null

    private var provisionAfterExtensions: Output<List<String>>? = null

    private var publisher: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settings: Output<Any>? = null

    private var suppressFailures: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    private var vmScaleSetName: Output<String>? = null

    private var vmssExtensionName: Output<String>? = null

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("ecijaclstntckapu")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("xvenjgmuwjtqjrdt")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
     */
    @JvmName("hnxrwhicbsyevdwq")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("blgojtiwfersckmo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("kpjsvcbctmaovhtp")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("dbouaasflnpmeqxu")
    public suspend fun protectedSettingsFromKeyVault(`value`: Output<KeyVaultSecretReferenceArgs>) {
        this.protectedSettingsFromKeyVault = value
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("byarbfmrsfprtyoa")
    public suspend fun provisionAfterExtensions(`value`: Output<List<String>>) {
        this.provisionAfterExtensions = value
    }

    @JvmName("turcrndlldxgnxyb")
    public suspend fun provisionAfterExtensions(vararg values: Output<String>) {
        this.provisionAfterExtensions = Output.all(values.asList())
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("vmlpjmvdswnyfgoe")
    public suspend fun provisionAfterExtensions(values: List<Output<String>>) {
        this.provisionAfterExtensions = Output.all(values)
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("bkdvhafxyhqgdalc")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("htkrabikkmlcmjrq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("apeetufqoammmwte")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("cnejfvcbwwbxydoy")
    public suspend fun suppressFailures(`value`: Output<Boolean>) {
        this.suppressFailures = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("gbkfrcgigjcsnaqh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("hdbfbvwyypvrmceg")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value The name of the VM scale set where the extension should be create or updated.
     */
    @JvmName("dbjclstovdlyhjlp")
    public suspend fun vmScaleSetName(`value`: Output<String>) {
        this.vmScaleSetName = value
    }

    /**
     * @param value The name of the VM scale set extension.
     */
    @JvmName("sphloxkquxviymrg")
    public suspend fun vmssExtensionName(`value`: Output<String>) {
        this.vmssExtensionName = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("chslmpdbatfgwvfn")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("nlgckvlgxncbkjst")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
     */
    @JvmName("qfumeesuxanwkgtt")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("wvlwjfgmrlafrtcp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("tatiqajchldscygh")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("hxowwcfouhlesqvg")
    public suspend fun protectedSettingsFromKeyVault(`value`: KeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param argument The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("ikmxkviouwnhexuc")
    public suspend
    fun protectedSettingsFromKeyVault(argument: suspend KeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("wmxorqfdcfhjfkre")
    public suspend fun provisionAfterExtensions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("sukaskdnsnrtrejp")
    public suspend fun provisionAfterExtensions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("oijchmeiyleicxma")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ejoqlelffooyvrjo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("lyrtmgtsjhiqsriy")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("surdtjemjdqkuwos")
    public suspend fun suppressFailures(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressFailures = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("dvejifhjmarypjyf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("fjdfytcboddhojfk")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    /**
     * @param value The name of the VM scale set where the extension should be create or updated.
     */
    @JvmName("synkafijnespusbx")
    public suspend fun vmScaleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScaleSetName = mapped
    }

    /**
     * @param value The name of the VM scale set extension.
     */
    @JvmName("guhuobqhbrnwcoox")
    public suspend fun vmssExtensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmssExtensionName = mapped
    }

    internal fun build(): VirtualMachineScaleSetExtensionArgs = VirtualMachineScaleSetExtensionArgs(
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
        forceUpdateTag = forceUpdateTag,
        name = name,
        protectedSettings = protectedSettings,
        protectedSettingsFromKeyVault = protectedSettingsFromKeyVault,
        provisionAfterExtensions = provisionAfterExtensions,
        publisher = publisher,
        resourceGroupName = resourceGroupName,
        settings = settings,
        suppressFailures = suppressFailures,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
        vmScaleSetName = vmScaleSetName,
        vmssExtensionName = vmssExtensionName,
    )
}
