@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.AdditionalCapabilitiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.AdditionalCapabilitiesArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.DiagnosticsProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DiagnosticsProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.HardwareProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.HardwareProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.OSProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.OSProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SecurityProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SecurityProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.StorageProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.StorageProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineIdentityArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineIdentityArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetVMProtectionPolicyArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineScaleSetVMProtectionPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set virtual machine.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualMachineScaleSetVM_Update_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetVM = new AzureNative.Compute.VirtualMachineScaleSetVM("virtualMachineScaleSetVM", new()
 *     {
 *         AdditionalCapabilities = new AzureNative.Compute.Inputs.AdditionalCapabilitiesArgs
 *         {
 *             HibernationEnabled = true,
 *             UltraSSDEnabled = true,
 *         },
 *         AvailabilitySet = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *         },
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "aaaaaaaaaaaaa",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = "Basic_A0",
 *             VmSizeProperties = new AzureNative.Compute.Inputs.VMSizePropertiesArgs
 *             {
 *                 VCPUsAvailable = 9,
 *                 VCPUsPerCore = 12,
 *             },
 *         },
 *         InstanceId = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *         LicenseType = "aaaaaaaaaa",
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkApiVersion = "2020-11-01",
 *             NetworkInterfaceConfigurations = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceConfigurationArgs
 *                 {
 *                     DeleteOption = "Delete",
 *                     DnsSettings = new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs
 *                     {
 *                         DnsServers = new[]
 *                         {
 *                             "aaaaaa",
 *                         },
 *                     },
 *                     DscpConfiguration = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                     },
 *                     EnableAcceleratedNetworking = true,
 *                     EnableFpga = true,
 *                     EnableIPForwarding = true,
 *                     IpConfigurations = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs
 *                         {
 *                             ApplicationGatewayBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             ApplicationSecurityGroups = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             LoadBalancerBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             Name = "aa",
 *                             Primary = true,
 *                             PrivateIPAddressVersion = "IPv4",
 *                             PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachinePublicIPAddressConfigurationArgs
 *                             {
 *                                 DeleteOption = "Delete",
 *                                 DnsSettings = new AzureNative.Compute.Inputs.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs
 *                                 {
 *                                     DomainNameLabel = "aaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                 },
 *                                 IdleTimeoutInMinutes = 2,
 *                                 IpTags = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.VirtualMachineIpTagArgs
 *                                     {
 *                                         IpTagType = "aaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                         Tag = "aaaaaaaaaaaaaaaaaaaa",
 *                                     },
 *                                 },
 *                                 Name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                 PublicIPAddressVersion = "IPv4",
 *                                 PublicIPAllocationMethod = "Dynamic",
 *                                 PublicIPPrefix = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                                 Sku = new AzureNative.Compute.Inputs.PublicIPAddressSkuArgs
 *                                 {
 *                                     Name = "Basic",
 *                                     Tier = "Regional",
 *                                 },
 *                             },
 *                             Subnet = new AzureNative.Compute.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                             },
 *                         },
 *                     },
 *                     Name = "aaaaaaaaaaa",
 *                     NetworkSecurityGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                     },
 *                     Primary = true,
 *                 },
 *             },
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     DeleteOption = "Delete",
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{vmss-name}/virtualMachines/0/networkInterfaces/vmsstestnetconfig5415",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         NetworkProfileConfiguration = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgs
 *         {
 *             NetworkInterfaceConfigurations = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationArgs
 *                 {
 *                     DeleteOption = "Delete",
 *                     DnsSettings = new AzureNative.Compute.Inputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs
 *                     {
 *                         DnsServers = new() { },
 *                     },
 *                     EnableAcceleratedNetworking = true,
 *                     EnableFpga = true,
 *                     EnableIPForwarding = true,
 *                     IpConfigurations = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.VirtualMachineScaleSetIPConfigurationArgs
 *                         {
 *                             ApplicationGatewayBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             ApplicationSecurityGroups = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             LoadBalancerBackendAddressPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             LoadBalancerInboundNatPools = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                             },
 *                             Name = "vmsstestnetconfig9693",
 *                             Primary = true,
 *                             PrivateIPAddressVersion = "IPv4",
 *                             PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachineScaleSetPublicIPAddressConfigurationArgs
 *                             {
 *                                 DeleteOption = "Delete",
 *                                 DnsSettings = new AzureNative.Compute.Inputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs
 *                                 {
 *                                     DomainNameLabel = "aaaaaaaaaaaaaaaaaa",
 *                                 },
 *                                 IdleTimeoutInMinutes = 18,
 *                                 IpTags = new[]
 *                                 {
 *                                     new AzureNative.Compute.Inputs.VirtualMachineScaleSetIpTagArgs
 *                                     {
 *                                         IpTagType = "aaaaaaa",
 *                                         Tag = "aaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *                                     },
 *                                 },
 *                                 Name = "aaaaaaaaaaaaaaaaaa",
 *                                 PublicIPAddressVersion = "IPv4",
 *                                 PublicIPPrefix = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                 {
 *                                     Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                                 },
 *                                 Sku = new AzureNative.Compute.Inputs.PublicIPAddressSkuArgs
 *                                 {
 *                                     Name = "Basic",
 *                                     Tier = "Regional",
 *                                 },
 *                             },
 *                             Subnet = new AzureNative.Compute.Inputs.ApiEntityReferenceArgs
 *                             {
 *                                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/vn4071/subnets/sn5503",
 *                             },
 *                         },
 *                     },
 *                     Name = "vmsstestnetconfig5415",
 *                     NetworkSecurityGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                     },
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "aaaaaaaaaaaaaaaa",
 *             AdminUsername = "Foo12",
 *             AllowExtensionOperations = true,
 *             ComputerName = "test000000",
 *             CustomData = "aaaa",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 DisablePasswordAuthentication = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = "ImageDefault",
 *                     PatchMode = "ImageDefault",
 *                 },
 *                 ProvisionVMAgent = true,
 *                 Ssh = new AzureNative.Compute.Inputs.SshConfigurationArgs
 *                 {
 *                     PublicKeys = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.SshPublicKeyArgs
 *                         {
 *                             KeyData = "aaaaaa",
 *                             Path = "aaa",
 *                         },
 *                     },
 *                 },
 *             },
 *             RequireGuestProvisionSignal = true,
 *             Secrets = new() { },
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 AdditionalUnattendContent = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.AdditionalUnattendContentArgs
 *                     {
 *                         ComponentName = AzureNative.Compute.ComponentNames.Microsoft_Windows_Shell_Setup,
 *                         Content = "aaaaaaaaaaaaaaaaaaaa",
 *                         PassName = AzureNative.Compute.PassNames.OobeSystem,
 *                         SettingName = AzureNative.Compute.SettingNames.AutoLogon,
 *                     },
 *                 },
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = "ImageDefault",
 *                     EnableHotpatching = true,
 *                     PatchMode = "Manual",
 *                 },
 *                 ProvisionVMAgent = true,
 *                 TimeZone = "aaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *                 WinRM = new AzureNative.Compute.Inputs.WinRMConfigurationArgs
 *                 {
 *                     Listeners = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.WinRMListenerArgs
 *                         {
 *                             CertificateUrl = "aaaaaaaaaaaaaaaaaaaaaa",
 *                             Protocol = AzureNative.Compute.ProtocolTypes.Http,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "aaaaaaaaaa",
 *             Product = "aaaaaaaaaaaaaaaaaaaa",
 *             PromotionCode = "aaaaaaaaaaaaaaaaaaaa",
 *             Publisher = "aaaaaaaaaaaaaaaaaaaaaa",
 *         },
 *         ProtectionPolicy = new AzureNative.Compute.Inputs.VirtualMachineScaleSetVMProtectionPolicyArgs
 *         {
 *             ProtectFromScaleIn = true,
 *             ProtectFromScaleSetActions = true,
 *         },
 *         ResourceGroupName = "rgcompute",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             EncryptionAtHost = true,
 *             SecurityType = "TrustedLaunch",
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.None,
 *                     CreateOption = "Empty",
 *                     DeleteOption = "Delete",
 *                     DetachOption = "ForceDetach",
 *                     DiskSizeGB = 128,
 *                     Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                     },
 *                     Lun = 1,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "aaaaaaaaaaaa",
 *                         },
 *                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d",
 *                         StorageAccountType = "Standard_LRS",
 *                     },
 *                     Name = "vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d",
 *                     ToBeDetached = true,
 *                     Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                     },
 *                     WriteAcceleratorEnabled = true,
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "a",
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 SharedGalleryImageId = "aaaaaaaaaaaaaaaaaaaa",
 *                 Sku = "2012-R2-Datacenter",
 *                 Version = "4.127.20180315",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.None,
 *                 CreateOption = "FromImage",
 *                 DeleteOption = "Delete",
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = "Local",
 *                     Placement = "CacheDisk",
 *                 },
 *                 DiskSizeGB = 127,
 *                 EncryptionSettings = new AzureNative.Compute.Inputs.DiskEncryptionSettingsArgs
 *                 {
 *                     DiskEncryptionKey = new AzureNative.Compute.Inputs.KeyVaultSecretReferenceArgs
 *                     {
 *                         SecretUrl = "aaaaaaaa",
 *                         SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                         },
 *                     },
 *                     Enabled = true,
 *                     KeyEncryptionKey = new AzureNative.Compute.Inputs.KeyVaultKeyReferenceArgs
 *                     {
 *                         KeyUrl = "aaaaaaaaaaaaaa",
 *                         SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}",
 *                         },
 *                     },
 *                 },
 *                 Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                     {
 *                         Id = "aaaaaaaaaaaa",
 *                     },
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc",
 *                     StorageAccountType = "Standard_LRS",
 *                 },
 *                 Name = "vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc",
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *                 Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd",
 *                 },
 *                 WriteAcceleratorEnabled = true,
 *             },
 *         },
 *         Tags = null,
 *         UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         VmScaleSetName = "aaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewVirtualMachineScaleSetVM(ctx, "virtualMachineScaleSetVM", &compute.VirtualMachineScaleSetVMArgs{
 * AdditionalCapabilities: &compute.AdditionalCapabilitiesArgs{
 * HibernationEnabled: pulumi.Bool(true),
 * UltraSSDEnabled: pulumi.Bool(true),
 * },
 * AvailabilitySet: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * DiagnosticsProfile: compute.DiagnosticsProfileResponse{
 * BootDiagnostics: &compute.BootDiagnosticsArgs{
 * Enabled: pulumi.Bool(true),
 * StorageUri: pulumi.String("aaaaaaaaaaaaa"),
 * },
 * },
 * HardwareProfile: compute.HardwareProfileResponse{
 * VmSize: pulumi.String("Basic_A0"),
 * VmSizeProperties: &compute.VMSizePropertiesArgs{
 * VCPUsAvailable: pulumi.Int(9),
 * VCPUsPerCore: pulumi.Int(12),
 * },
 * },
 * InstanceId: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * LicenseType: pulumi.String("aaaaaaaaaa"),
 * Location: pulumi.String("westus"),
 * NetworkProfile: compute.NetworkProfileResponse{
 * NetworkApiVersion: pulumi.String("2020-11-01"),
 * NetworkInterfaceConfigurations: compute.VirtualMachineNetworkInterfaceConfigurationArray{
 * interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs{
 * DnsServers: pulumi.StringArray{
 * pulumi.String("aaaaaa"),
 * },
 * },
 * DscpConfiguration: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * EnableAcceleratedNetworking: pulumi.Bool(true),
 * EnableFpga: pulumi.Bool(true),
 * EnableIPForwarding: pulumi.Bool(true),
 * IpConfigurations: compute.VirtualMachineNetworkInterfaceIPConfigurationArray{
 * interface{}{
 * ApplicationGatewayBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * ApplicationSecurityGroups: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * LoadBalancerBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * Name: pulumi.String("aa"),
 * Primary: pulumi.Bool(true),
 * PrivateIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPAddressConfiguration: interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs{
 * DomainNameLabel: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaa"),
 * },
 * IdleTimeoutInMinutes: pulumi.Int(2),
 * IpTags: compute.VirtualMachineIpTagArray{
 * &compute.VirtualMachineIpTagArgs{
 * IpTagType: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaa"),
 * Tag: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * },
 * },
 * Name: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * PublicIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPAllocationMethod: pulumi.String("Dynamic"),
 * PublicIPPrefix: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Sku: &compute.PublicIPAddressSkuArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Regional"),
 * },
 * },
 * Subnet: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * },
 * Name: pulumi.String("aaaaaaaaaaa"),
 * NetworkSecurityGroup: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Primary: pulumi.Bool(true),
 * },
 * },
 * NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * &compute.NetworkInterfaceReferenceArgs{
 * DeleteOption: pulumi.String("Delete"),
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{vmss-name}/virtualMachines/0/networkInterfaces/vmsstestnetconfig5415"),
 * Primary: pulumi.Bool(true),
 * },
 * },
 * },
 * NetworkProfileConfiguration: compute.VirtualMachineScaleSetVMNetworkProfileConfigurationResponse{
 * NetworkInterfaceConfigurations: compute.VirtualMachineScaleSetNetworkConfigurationArray{
 * interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachineScaleSetNetworkConfigurationDnsSettingsArgs{
 * DnsServers: pulumi.StringArray{
 * },
 * },
 * EnableAcceleratedNetworking: pulumi.Bool(true),
 * EnableFpga: pulumi.Bool(true),
 * EnableIPForwarding: pulumi.Bool(true),
 * IpConfigurations: compute.VirtualMachineScaleSetIPConfigurationArray{
 * interface{}{
 * ApplicationGatewayBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * ApplicationSecurityGroups: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * LoadBalancerBackendAddressPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * LoadBalancerInboundNatPools: compute.SubResourceArray{
 * &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * Name: pulumi.String("vmsstestnetconfig9693"),
 * Primary: pulumi.Bool(true),
 * PrivateIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPAddressConfiguration: interface{}{
 * DeleteOption: pulumi.String("Delete"),
 * DnsSettings: &compute.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsArgs{
 * DomainNameLabel: pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * },
 * IdleTimeoutInMinutes: pulumi.Int(18),
 * IpTags: compute.VirtualMachineScaleSetIpTagArray{
 * &compute.VirtualMachineScaleSetIpTagArgs{
 * IpTagType: pulumi.String("aaaaaaa"),
 * Tag: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * },
 * },
 * Name: pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * PublicIPAddressVersion: pulumi.String("IPv4"),
 * PublicIPPrefix: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Sku: &compute.PublicIPAddressSkuArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Regional"),
 * },
 * },
 * Subnet: &compute.ApiEntityReferenceArgs{
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/vn4071/subnets/sn5503"),
 * },
 * },
 * },
 * Name: pulumi.String("vmsstestnetconfig5415"),
 * NetworkSecurityGroup: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * Primary: pulumi.Bool(true),
 * },
 * },
 * },
 * OsProfile: compute.OSProfileResponse{
 * AdminPassword: pulumi.String("aaaaaaaaaaaaaaaa"),
 * AdminUsername: pulumi.String("Foo12"),
 * AllowExtensionOperations: pulumi.Bool(true),
 * ComputerName: pulumi.String("test000000"),
 * CustomData: pulumi.String("aaaa"),
 * LinuxConfiguration: interface{}{
 * DisablePasswordAuthentication: pulumi.Bool(true),
 * PatchSettings: &compute.LinuxPatchSettingsArgs{
 * AssessmentMode: pulumi.String("ImageDefault"),
 * PatchMode: pulumi.String("ImageDefault"),
 * },
 * ProvisionVMAgent: pulumi.Bool(true),
 * Ssh: interface{}{
 * PublicKeys: compute.SshPublicKeyTypeArray{
 * &compute.SshPublicKeyTypeArgs{
 * KeyData: pulumi.String("aaaaaa"),
 * Path: pulumi.String("aaa"),
 * },
 * },
 * },
 * },
 * RequireGuestProvisionSignal: pulumi.Bool(true),
 * Secrets: compute.VaultSecretGroupArray{
 * },
 * WindowsConfiguration: interface{}{
 * AdditionalUnattendContent: compute.AdditionalUnattendContentArray{
 * &compute.AdditionalUnattendContentArgs{
 * ComponentName: compute.ComponentNames_Microsoft_Windows_Shell_Setup,
 * Content: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * PassName: compute.PassNamesOobeSystem,
 * SettingName: compute.SettingNamesAutoLogon,
 * },
 * },
 * EnableAutomaticUpdates: pulumi.Bool(true),
 * PatchSettings: &compute.PatchSettingsArgs{
 * AssessmentMode: pulumi.String("ImageDefault"),
 * EnableHotpatching: pulumi.Bool(true),
 * PatchMode: pulumi.String("Manual"),
 * },
 * ProvisionVMAgent: pulumi.Bool(true),
 * TimeZone: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * WinRM: interface{}{
 * Listeners: compute.WinRMListenerArray{
 * &compute.WinRMListenerArgs{
 * CertificateUrl: pulumi.String("aaaaaaaaaaaaaaaaaaaaaa"),
 * Protocol: compute.ProtocolTypesHttp,
 * },
 * },
 * },
 * },
 * },
 * Plan: &compute.PlanArgs{
 * Name: pulumi.String("aaaaaaaaaa"),
 * Product: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * PromotionCode: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * Publisher: pulumi.String("aaaaaaaaaaaaaaaaaaaaaa"),
 * },
 * ProtectionPolicy: &compute.VirtualMachineScaleSetVMProtectionPolicyArgs{
 * ProtectFromScaleIn: pulumi.Bool(true),
 * ProtectFromScaleSetActions: pulumi.Bool(true),
 * },
 * ResourceGroupName: pulumi.String("rgcompute"),
 * SecurityProfile: compute.SecurityProfileResponse{
 * EncryptionAtHost: pulumi.Bool(true),
 * SecurityType: pulumi.String("TrustedLaunch"),
 * UefiSettings: &compute.UefiSettingsArgs{
 * SecureBootEnabled: pulumi.Bool(true),
 * VTpmEnabled: pulumi.Bool(true),
 * },
 * },
 * StorageProfile: compute.StorageProfileResponse{
 * DataDisks: compute.DataDiskArray{
 * interface{}{
 * Caching: compute.CachingTypesNone,
 * CreateOption: pulumi.String("Empty"),
 * DeleteOption: pulumi.String("Delete"),
 * DetachOption: pulumi.String("ForceDetach"),
 * DiskSizeGB: pulumi.Int(128),
 * Image: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * Lun: pulumi.Int(1),
 * ManagedDisk: interface{}{
 * DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * Id: pulumi.String("aaaaaaaaaaaa"),
 * },
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 * StorageAccountType: pulumi.String("Standard_LRS"),
 * },
 * Name: pulumi.String("vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 * ToBeDetached: pulumi.Bool(true),
 * Vhd: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * WriteAcceleratorEnabled: pulumi.Bool(true),
 * },
 * },
 * ImageReference: &compute.ImageReferenceArgs{
 * Id: pulumi.String("a"),
 * Offer: pulumi.String("WindowsServer"),
 * Publisher: pulumi.String("MicrosoftWindowsServer"),
 * SharedGalleryImageId: pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * Sku: pulumi.String("2012-R2-Datacenter"),
 * Version: pulumi.String("4.127.20180315"),
 * },
 * OsDisk: interface{}{
 * Caching: compute.CachingTypesNone,
 * CreateOption: pulumi.String("FromImage"),
 * DeleteOption: pulumi.String("Delete"),
 * DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * Option: pulumi.String("Local"),
 * Placement: pulumi.String("CacheDisk"),
 * },
 * DiskSizeGB: pulumi.Int(127),
 * EncryptionSettings: interface{}{
 * DiskEncryptionKey: interface{}{
 * SecretUrl: pulumi.String("aaaaaaaa"),
 * SourceVault: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * Enabled: pulumi.Bool(true),
 * KeyEncryptionKey: interface{}{
 * KeyUrl: pulumi.String("aaaaaaaaaaaaaa"),
 * SourceVault: &compute.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"),
 * },
 * },
 * },
 * Image: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * ManagedDisk: interface{}{
 * DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * Id: pulumi.String("aaaaaaaaaaaa"),
 * },
 * Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 * StorageAccountType: pulumi.String("Standard_LRS"),
 * },
 * Name: pulumi.String("vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 * OsType: compute.OperatingSystemTypesWindows,
 * Vhd: &compute.VirtualHardDiskArgs{
 * Uri: pulumi.String("https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd"),
 * },
 * WriteAcceleratorEnabled: pulumi.Bool(true),
 * },
 * },
 * Tags: nil,
 * UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * VmScaleSetName: pulumi.String("aaaaaaaaaaaaaa"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVM;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetVM = new VirtualMachineScaleSetVM("virtualMachineScaleSetVM", VirtualMachineScaleSetVMArgs.builder()
 *             .additionalCapabilities(Map.ofEntries(
 *                 Map.entry("hibernationEnabled", true),
 *                 Map.entry("ultraSSDEnabled", true)
 *             ))
 *             .availabilitySet(Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *             .diagnosticsProfile(Map.of("bootDiagnostics", Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("storageUri", "aaaaaaaaaaaaa")
 *             )))
 *             .hardwareProfile(Map.ofEntries(
 *                 Map.entry("vmSize", "Basic_A0"),
 *                 Map.entry("vmSizeProperties", Map.ofEntries(
 *                     Map.entry("vCPUsAvailable", 9),
 *                     Map.entry("vCPUsPerCore", 12)
 *                 ))
 *             ))
 *             .instanceId("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa")
 *             .licenseType("aaaaaaaaaa")
 *             .location("westus")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("networkApiVersion", "2020-11-01"),
 *                 Map.entry("networkInterfaceConfigurations", Map.ofEntries(
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("dnsSettings", Map.of("dnsServers", "aaaaaa")),
 *                     Map.entry("dscpConfiguration", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("enableAcceleratedNetworking", true),
 *                     Map.entry("enableFpga", true),
 *                     Map.entry("enableIPForwarding", true),
 *                     Map.entry("ipConfigurations", Map.ofEntries(
 *                         Map.entry("applicationGatewayBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("applicationSecurityGroups", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("loadBalancerBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("name", "aa"),
 *                         Map.entry("primary", true),
 *                         Map.entry("privateIPAddressVersion", "IPv4"),
 *                         Map.entry("publicIPAddressConfiguration", Map.ofEntries(
 *                             Map.entry("deleteOption", "Delete"),
 *                             Map.entry("dnsSettings", Map.of("domainNameLabel", "aaaaaaaaaaaaaaaaaaaaaaaaa")),
 *                             Map.entry("idleTimeoutInMinutes", 2),
 *                             Map.entry("ipTags", Map.ofEntries(
 *                                 Map.entry("ipTagType", "aaaaaaaaaaaaaaaaaaaaaaaaa"),
 *                                 Map.entry("tag", "aaaaaaaaaaaaaaaaaaaa")
 *                             )),
 *                             Map.entry("name", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 *                             Map.entry("publicIPAddressVersion", "IPv4"),
 *                             Map.entry("publicIPAllocationMethod", "Dynamic"),
 *                             Map.entry("publicIPPrefix", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                             Map.entry("sku", Map.ofEntries(
 *                                 Map.entry("name", "Basic"),
 *                                 Map.entry("tier", "Regional")
 *                             ))
 *                         )),
 *                         Map.entry("subnet", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *                     )),
 *                     Map.entry("name", "aaaaaaaaaaa"),
 *                     Map.entry("networkSecurityGroup", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("primary", true)
 *                 )),
 *                 Map.entry("networkInterfaces", Map.ofEntries(
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{vmss-name}/virtualMachines/0/networkInterfaces/vmsstestnetconfig5415"),
 *                     Map.entry("primary", true)
 *                 ))
 *             ))
 *             .networkProfileConfiguration(Map.of("networkInterfaceConfigurations", Map.ofEntries(
 *                 Map.entry("deleteOption", "Delete"),
 *                 Map.entry("dnsSettings", Map.of("dnsServers", )),
 *                 Map.entry("enableAcceleratedNetworking", true),
 *                 Map.entry("enableFpga", true),
 *                 Map.entry("enableIPForwarding", true),
 *                 Map.entry("ipConfigurations", Map.ofEntries(
 *                     Map.entry("applicationGatewayBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("applicationSecurityGroups", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("loadBalancerBackendAddressPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("loadBalancerInboundNatPools", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                     Map.entry("name", "vmsstestnetconfig9693"),
 *                     Map.entry("primary", true),
 *                     Map.entry("privateIPAddressVersion", "IPv4"),
 *                     Map.entry("publicIPAddressConfiguration", Map.ofEntries(
 *                         Map.entry("deleteOption", "Delete"),
 *                         Map.entry("dnsSettings", Map.of("domainNameLabel", "aaaaaaaaaaaaaaaaaa")),
 *                         Map.entry("idleTimeoutInMinutes", 18),
 *                         Map.entry("ipTags", Map.ofEntries(
 *                             Map.entry("ipTagType", "aaaaaaa"),
 *                             Map.entry("tag", "aaaaaaaaaaaaaaaaaaaaaaaaaaa")
 *                         )),
 *                         Map.entry("name", "aaaaaaaaaaaaaaaaaa"),
 *                         Map.entry("publicIPAddressVersion", "IPv4"),
 *                         Map.entry("publicIPPrefix", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                         Map.entry("sku", Map.ofEntries(
 *                             Map.entry("name", "Basic"),
 *                             Map.entry("tier", "Regional")
 *                         ))
 *                     )),
 *                     Map.entry("subnet", Map.of("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/vn4071/subnets/sn5503"))
 *                 )),
 *                 Map.entry("name", "vmsstestnetconfig5415"),
 *                 Map.entry("networkSecurityGroup", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")),
 *                 Map.entry("primary", true)
 *             )))
 *             .osProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "aaaaaaaaaaaaaaaa"),
 *                 Map.entry("adminUsername", "Foo12"),
 *                 Map.entry("allowExtensionOperations", true),
 *                 Map.entry("computerName", "test000000"),
 *                 Map.entry("customData", "aaaa"),
 *                 Map.entry("linuxConfiguration", Map.ofEntries(
 *                     Map.entry("disablePasswordAuthentication", true),
 *                     Map.entry("patchSettings", Map.ofEntries(
 *                         Map.entry("assessmentMode", "ImageDefault"),
 *                         Map.entry("patchMode", "ImageDefault")
 *                     )),
 *                     Map.entry("provisionVMAgent", true),
 *                     Map.entry("ssh", Map.of("publicKeys", Map.ofEntries(
 *                         Map.entry("keyData", "aaaaaa"),
 *                         Map.entry("path", "aaa")
 *                     )))
 *                 )),
 *                 Map.entry("requireGuestProvisionSignal", true),
 *                 Map.entry("secrets", ),
 *                 Map.entry("windowsConfiguration", Map.ofEntries(
 *                     Map.entry("additionalUnattendContent", Map.ofEntries(
 *                         Map.entry("componentName", "Microsoft-Windows-Shell-Setup"),
 *                         Map.entry("content", "aaaaaaaaaaaaaaaaaaaa"),
 *                         Map.entry("passName", "OobeSystem"),
 *                         Map.entry("settingName", "AutoLogon")
 *                     )),
 *                     Map.entry("enableAutomaticUpdates", true),
 *                     Map.entry("patchSettings", Map.ofEntries(
 *                         Map.entry("assessmentMode", "ImageDefault"),
 *                         Map.entry("enableHotpatching", true),
 *                         Map.entry("patchMode", "Manual")
 *                     )),
 *                     Map.entry("provisionVMAgent", true),
 *                     Map.entry("timeZone", "aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("winRM", Map.of("listeners", Map.ofEntries(
 *                         Map.entry("certificateUrl", "aaaaaaaaaaaaaaaaaaaaaa"),
 *                         Map.entry("protocol", "Http")
 *                     )))
 *                 ))
 *             ))
 *             .plan(Map.ofEntries(
 *                 Map.entry("name", "aaaaaaaaaa"),
 *                 Map.entry("product", "aaaaaaaaaaaaaaaaaaaa"),
 *                 Map.entry("promotionCode", "aaaaaaaaaaaaaaaaaaaa"),
 *                 Map.entry("publisher", "aaaaaaaaaaaaaaaaaaaaaa")
 *             ))
 *             .protectionPolicy(Map.ofEntries(
 *                 Map.entry("protectFromScaleIn", true),
 *                 Map.entry("protectFromScaleSetActions", true)
 *             ))
 *             .resourceGroupName("rgcompute")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("encryptionAtHost", true),
 *                 Map.entry("securityType", "TrustedLaunch"),
 *                 Map.entry("uefiSettings", Map.ofEntries(
 *                     Map.entry("secureBootEnabled", true),
 *                     Map.entry("vTpmEnabled", true)
 *                 ))
 *             ))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("dataDisks", Map.ofEntries(
 *                     Map.entry("caching", "None"),
 *                     Map.entry("createOption", "Empty"),
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("detachOption", "ForceDetach"),
 *                     Map.entry("diskSizeGB", 128),
 *                     Map.entry("image", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("lun", 1),
 *                     Map.entry("managedDisk", Map.ofEntries(
 *                         Map.entry("diskEncryptionSet", Map.of("id", "aaaaaaaaaaaa")),
 *                         Map.entry("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 *                         Map.entry("storageAccountType", "Standard_LRS")
 *                     )),
 *                     Map.entry("name", "vmss3176_vmss3176_0_disk2_6c4f554bdafa49baa780eb2d128ff39d"),
 *                     Map.entry("toBeDetached", true),
 *                     Map.entry("vhd", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("writeAcceleratorEnabled", true)
 *                 )),
 *                 Map.entry("imageReference", Map.ofEntries(
 *                     Map.entry("id", "a"),
 *                     Map.entry("offer", "WindowsServer"),
 *                     Map.entry("publisher", "MicrosoftWindowsServer"),
 *                     Map.entry("sharedGalleryImageId", "aaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("sku", "2012-R2-Datacenter"),
 *                     Map.entry("version", "4.127.20180315")
 *                 )),
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("caching", "None"),
 *                     Map.entry("createOption", "FromImage"),
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("diffDiskSettings", Map.ofEntries(
 *                         Map.entry("option", "Local"),
 *                         Map.entry("placement", "CacheDisk")
 *                     )),
 *                     Map.entry("diskSizeGB", 127),
 *                     Map.entry("encryptionSettings", Map.ofEntries(
 *                         Map.entry("diskEncryptionKey", Map.ofEntries(
 *                             Map.entry("secretUrl", "aaaaaaaa"),
 *                             Map.entry("sourceVault", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *                         )),
 *                         Map.entry("enabled", true),
 *                         Map.entry("keyEncryptionKey", Map.ofEntries(
 *                             Map.entry("keyUrl", "aaaaaaaaaaaaaa"),
 *                             Map.entry("sourceVault", Map.of("id", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}"))
 *                         ))
 *                     )),
 *                     Map.entry("image", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("managedDisk", Map.ofEntries(
 *                         Map.entry("diskEncryptionSet", Map.of("id", "aaaaaaaaaaaa")),
 *                         Map.entry("id", "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 *                         Map.entry("storageAccountType", "Standard_LRS")
 *                     )),
 *                     Map.entry("name", "vmss3176_vmss3176_0_OsDisk_1_6d72b805e50e4de6830303c5055077fc"),
 *                     Map.entry("osType", "Windows"),
 *                     Map.entry("vhd", Map.of("uri", "https://{storageAccountName}.blob.core.windows.net/{containerName}/{vhdName}.vhd")),
 *                     Map.entry("writeAcceleratorEnabled", true)
 *                 ))
 *             ))
 *             .tags()
 *             .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *             .vmScaleSetName("aaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ### VirtualMachineScaleSetVM_Update_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineScaleSetVM = new AzureNative.Compute.VirtualMachineScaleSetVM("virtualMachineScaleSetVM", new()
 *     {
 *         InstanceId = "aaaaaaaaaaaaaaaaaaaa",
 *         Location = "westus",
 *         ResourceGroupName = "rgcompute",
 *         VmScaleSetName = "aaaaaaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineScaleSetVM(ctx, "virtualMachineScaleSetVM", &compute.VirtualMachineScaleSetVMArgs{
 * 			InstanceId:        pulumi.String("aaaaaaaaaaaaaaaaaaaa"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			VmScaleSetName:    pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVM;
 * import com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineScaleSetVM = new VirtualMachineScaleSetVM("virtualMachineScaleSetVM", VirtualMachineScaleSetVMArgs.builder()
 *             .instanceId("aaaaaaaaaaaaaaaaaaaa")
 *             .location("westus")
 *             .resourceGroupName("rgcompute")
 *             .vmScaleSetName("aaaaaaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineScaleSetVM {vmss-vm-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}
 * ```
 * @property additionalCapabilities Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
 * @property availabilitySet Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.
 * @property diagnosticsProfile Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property hardwareProfile Specifies the hardware settings for the virtual machine.
 * @property identity The identity of the virtual machine, if configured.
 * @property instanceId The instance ID of the virtual machine.
 * @property licenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
 * @property location Resource location
 * @property networkProfile Specifies the network interfaces of the virtual machine.
 * @property networkProfileConfiguration Specifies the network profile configuration of the virtual machine.
 * @property osProfile Specifies the operating system settings for the virtual machine.
 * @property plan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property protectionPolicy Specifies the protection policy of the virtual machine.
 * @property resourceGroupName The name of the resource group.
 * @property securityProfile Specifies the Security related profile settings for the virtual machine.
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property tags Resource tags
 * @property userData UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
 * @property vmScaleSetName The name of the VM scale set where the extension should be create or updated.
 */
public data class VirtualMachineScaleSetVMArgs(
    public val additionalCapabilities: Output<AdditionalCapabilitiesArgs>? = null,
    public val availabilitySet: Output<SubResourceArgs>? = null,
    public val diagnosticsProfile: Output<DiagnosticsProfileArgs>? = null,
    public val hardwareProfile: Output<HardwareProfileArgs>? = null,
    public val identity: Output<VirtualMachineIdentityArgs>? = null,
    public val instanceId: Output<String>? = null,
    public val licenseType: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val networkProfileConfiguration:
    Output<VirtualMachineScaleSetVMNetworkProfileConfigurationArgs>? = null,
    public val osProfile: Output<OSProfileArgs>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val protectionPolicy: Output<VirtualMachineScaleSetVMProtectionPolicyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityProfile: Output<SecurityProfileArgs>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    public val vmScaleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs =
        com.pulumi.azurenative.compute.VirtualMachineScaleSetVMArgs.builder()
            .additionalCapabilities(
                additionalCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .availabilitySet(availabilitySet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diagnosticsProfile(
                diagnosticsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .licenseType(licenseType?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkProfileConfiguration(
                networkProfileConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protectionPolicy(protectionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineScaleSetVMArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMArgsBuilder internal constructor() {
    private var additionalCapabilities: Output<AdditionalCapabilitiesArgs>? = null

    private var availabilitySet: Output<SubResourceArgs>? = null

    private var diagnosticsProfile: Output<DiagnosticsProfileArgs>? = null

    private var hardwareProfile: Output<HardwareProfileArgs>? = null

    private var identity: Output<VirtualMachineIdentityArgs>? = null

    private var instanceId: Output<String>? = null

    private var licenseType: Output<String>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var networkProfileConfiguration:
        Output<VirtualMachineScaleSetVMNetworkProfileConfigurationArgs>? = null

    private var osProfile: Output<OSProfileArgs>? = null

    private var plan: Output<PlanArgs>? = null

    private var protectionPolicy: Output<VirtualMachineScaleSetVMProtectionPolicyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityProfile: Output<SecurityProfileArgs>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var vmScaleSetName: Output<String>? = null

    /**
     * @param value Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    @JvmName("eenrfoutquyqykgw")
    public suspend fun additionalCapabilities(`value`: Output<AdditionalCapabilitiesArgs>) {
        this.additionalCapabilities = value
    }

    /**
     * @param value Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.
     */
    @JvmName("uugnctstttehofvb")
    public suspend fun availabilitySet(`value`: Output<SubResourceArgs>) {
        this.availabilitySet = value
    }

    /**
     * @param value Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("rkxhrurrgxvixioo")
    public suspend fun diagnosticsProfile(`value`: Output<DiagnosticsProfileArgs>) {
        this.diagnosticsProfile = value
    }

    /**
     * @param value Specifies the hardware settings for the virtual machine.
     */
    @JvmName("mltancpvtnvjhthm")
    public suspend fun hardwareProfile(`value`: Output<HardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value The identity of the virtual machine, if configured.
     */
    @JvmName("xnvwmxvkyareulwq")
    public suspend fun identity(`value`: Output<VirtualMachineIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("vwkyxkcvastpiadu")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    @JvmName("mxnsntrgfbqgledv")
    public suspend fun licenseType(`value`: Output<String>) {
        this.licenseType = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("ucgmyfeoyrfaabaf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies the network interfaces of the virtual machine.
     */
    @JvmName("oyhmaaihsmndghel")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value Specifies the network profile configuration of the virtual machine.
     */
    @JvmName("iukvkhbgbrigxisa")
    public suspend
    fun networkProfileConfiguration(`value`: Output<VirtualMachineScaleSetVMNetworkProfileConfigurationArgs>) {
        this.networkProfileConfiguration = value
    }

    /**
     * @param value Specifies the operating system settings for the virtual machine.
     */
    @JvmName("vpympsgxsgbgxabt")
    public suspend fun osProfile(`value`: Output<OSProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("mjypmxonbwqtbyjo")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Specifies the protection policy of the virtual machine.
     */
    @JvmName("acrbeflbyvdvygig")
    public suspend
    fun protectionPolicy(`value`: Output<VirtualMachineScaleSetVMProtectionPolicyArgs>) {
        this.protectionPolicy = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wtbpsipgqfuclxqv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the Security related profile settings for the virtual machine.
     */
    @JvmName("wqqceiikgluiorvm")
    public suspend fun securityProfile(`value`: Output<SecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("obbfoqajnemdgyqc")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ktaefidjngtbopha")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
     */
    @JvmName("ekytchstfqxiwwrq")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value The name of the VM scale set where the extension should be create or updated.
     */
    @JvmName("oascgtwkdnkwjfuj")
    public suspend fun vmScaleSetName(`value`: Output<String>) {
        this.vmScaleSetName = value
    }

    /**
     * @param value Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    @JvmName("igripcjhalnhbfyr")
    public suspend fun additionalCapabilities(`value`: AdditionalCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCapabilities = mapped
    }

    /**
     * @param argument Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
     */
    @JvmName("sjcuuhumgjvywyeh")
    public suspend
    fun additionalCapabilities(argument: suspend AdditionalCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = AdditionalCapabilitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.additionalCapabilities = mapped
    }

    /**
     * @param value Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.
     */
    @JvmName("fpynokpnadecwpjk")
    public suspend fun availabilitySet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySet = mapped
    }

    /**
     * @param argument Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.
     */
    @JvmName("tawoimkauyyharje")
    public suspend fun availabilitySet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.availabilitySet = mapped
    }

    /**
     * @param value Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("jwftxebvtxcjhmuc")
    public suspend fun diagnosticsProfile(`value`: DiagnosticsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticsProfile = mapped
    }

    /**
     * @param argument Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("jnshirofbbmdubhj")
    public suspend
    fun diagnosticsProfile(argument: suspend DiagnosticsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnosticsProfile = mapped
    }

    /**
     * @param value Specifies the hardware settings for the virtual machine.
     */
    @JvmName("nugxedfddygsdgpq")
    public suspend fun hardwareProfile(`value`: HardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument Specifies the hardware settings for the virtual machine.
     */
    @JvmName("xlasdllvgeajovfa")
    public suspend fun hardwareProfile(argument: suspend HardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HardwareProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value The identity of the virtual machine, if configured.
     */
    @JvmName("ousjkmcdwcvkjntr")
    public suspend fun identity(`value`: VirtualMachineIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the virtual machine, if configured.
     */
    @JvmName("ncakaomkfiqctnti")
    public suspend fun identity(argument: suspend VirtualMachineIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The instance ID of the virtual machine.
     */
    @JvmName("wdkmtxdoubnjbktc")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    @JvmName("grxerrecwhhogqnd")
    public suspend fun licenseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("winoqetdetkgpkba")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies the network interfaces of the virtual machine.
     */
    @JvmName("nakgctvrgjersojh")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Specifies the network interfaces of the virtual machine.
     */
    @JvmName("nwdduratxqlhctne")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value Specifies the network profile configuration of the virtual machine.
     */
    @JvmName("qbhbjyubufwfvxty")
    public suspend
    fun networkProfileConfiguration(`value`: VirtualMachineScaleSetVMNetworkProfileConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfileConfiguration = mapped
    }

    /**
     * @param argument Specifies the network profile configuration of the virtual machine.
     */
    @JvmName("damikoclrdoeoglr")
    public suspend
    fun networkProfileConfiguration(argument: suspend VirtualMachineScaleSetVMNetworkProfileConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetVMNetworkProfileConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkProfileConfiguration = mapped
    }

    /**
     * @param value Specifies the operating system settings for the virtual machine.
     */
    @JvmName("xdjgsuwuoijhwhqc")
    public suspend fun osProfile(`value`: OSProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument Specifies the operating system settings for the virtual machine.
     */
    @JvmName("fcafjgjuxuhumnsq")
    public suspend fun osProfile(argument: suspend OSProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OSProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("bytavhprnphexske")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("qtcyiywdpjlpnyfr")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Specifies the protection policy of the virtual machine.
     */
    @JvmName("wmabxlrmtakbbper")
    public suspend fun protectionPolicy(`value`: VirtualMachineScaleSetVMProtectionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionPolicy = mapped
    }

    /**
     * @param argument Specifies the protection policy of the virtual machine.
     */
    @JvmName("slgmijfcyqccglkm")
    public suspend
    fun protectionPolicy(argument: suspend VirtualMachineScaleSetVMProtectionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineScaleSetVMProtectionPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.protectionPolicy = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ijauufmnfgmmkkte")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the Security related profile settings for the virtual machine.
     */
    @JvmName("gmucobkfeoxkljen")
    public suspend fun securityProfile(`value`: SecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Specifies the Security related profile settings for the virtual machine.
     */
    @JvmName("bscfxothvdwphxie")
    public suspend fun securityProfile(argument: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("sbjtycemglbedsnf")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("srvtssabinhmoyao")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ylfxwolrnciyetfn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("hrcmbbgspfegkxbi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. <br><br>Minimum api-version: 2021-03-01
     */
    @JvmName("wfvndpujxgdywler")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value The name of the VM scale set where the extension should be create or updated.
     */
    @JvmName("yplmftycbhrmesds")
    public suspend fun vmScaleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScaleSetName = mapped
    }

    internal fun build(): VirtualMachineScaleSetVMArgs = VirtualMachineScaleSetVMArgs(
        additionalCapabilities = additionalCapabilities,
        availabilitySet = availabilitySet,
        diagnosticsProfile = diagnosticsProfile,
        hardwareProfile = hardwareProfile,
        identity = identity,
        instanceId = instanceId,
        licenseType = licenseType,
        location = location,
        networkProfile = networkProfile,
        networkProfileConfiguration = networkProfileConfiguration,
        osProfile = osProfile,
        plan = plan,
        protectionPolicy = protectionPolicy,
        resourceGroupName = resourceGroupName,
        securityProfile = securityProfile,
        storageProfile = storageProfile,
        tags = tags,
        userData = userData,
        vmScaleSetName = vmScaleSetName,
    )
}
