@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Additional authentication requirements when exporting or uploading to a disk or snapshot.
 */
public enum class DataAccessAuthMode(
    public val javaValue: com.pulumi.azurenative.compute.enums.DataAccessAuthMode,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DataAccessAuthMode> {
    /**
     * When export/upload URL is used, the system checks if the user has an identity in Azure Active Directory and has necessary permissions to export/upload the data. Please refer to aka.ms/DisksAzureADAuth.
     */
    AzureActiveDirectory(com.pulumi.azurenative.compute.enums.DataAccessAuthMode.AzureActiveDirectory),

    /**
     * No additional authentication would be performed when accessing export/upload URL.
     */
    None(com.pulumi.azurenative.compute.enums.DataAccessAuthMode.None),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DataAccessAuthMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DataAccessAuthMode):
            DataAccessAuthMode = DataAccessAuthMode.values().first { it.javaValue == javaType }
    }
}
