@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.
 */
public enum class DiskControllerTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskControllerTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskControllerTypes> {
    SCSI(com.pulumi.azurenative.compute.enums.DiskControllerTypes.SCSI),
    NVMe(com.pulumi.azurenative.compute.enums.DiskControllerTypes.NVMe),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskControllerTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskControllerTypes):
            DiskControllerTypes = DiskControllerTypes.values().first { it.javaValue == javaType }
    }
}
