@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview** mode and is not supported for VirtualMachineScaleSet. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
 */
public enum class DiskDetachOptionTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskDetachOptionTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskDetachOptionTypes> {
    ForceDetach(com.pulumi.azurenative.compute.enums.DiskDetachOptionTypes.ForceDetach),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskDetachOptionTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskDetachOptionTypes):
            DiskDetachOptionTypes = DiskDetachOptionTypes.values().first { it.javaValue == javaType }
    }
}
