@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of key used to encrypt the data of the disk.
 */
public enum class DiskEncryptionSetType(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskEncryptionSetType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskEncryptionSetType> {
    /**
     * Resource using diskEncryptionSet would be encrypted at rest with Customer managed key that can be changed and revoked by a customer.
     */
    EncryptionAtRestWithCustomerKey(com.pulumi.azurenative.compute.enums.DiskEncryptionSetType.EncryptionAtRestWithCustomerKey),

    /**
     * Resource using diskEncryptionSet would be encrypted at rest with two layers of encryption. One of the keys is Customer managed and the other key is Platform managed.
     */
    EncryptionAtRestWithPlatformAndCustomerKeys(com.pulumi.azurenative.compute.enums.DiskEncryptionSetType.EncryptionAtRestWithPlatformAndCustomerKeys),

    /**
     * Confidential VM supported disk and VM guest state would be encrypted with customer managed key.
     */
    ConfidentialVmEncryptedWithCustomerKey(com.pulumi.azurenative.compute.enums.DiskEncryptionSetType.ConfidentialVmEncryptedWithCustomerKey),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskEncryptionSetType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskEncryptionSetType):
            DiskEncryptionSetType = DiskEncryptionSetType.values().first { it.javaValue == javaType }
    }
}
