@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the SecurityType of the VM. Applicable for OS disks only.
 */
public enum class DiskSecurityTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskSecurityTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskSecurityTypes> {
    /**
     * Trusted Launch provides security features such as secure boot and virtual Trusted Platform Module (vTPM)
     */
    TrustedLaunch(com.pulumi.azurenative.compute.enums.DiskSecurityTypes.TrustedLaunch),

    /**
     * Indicates Confidential VM disk with only VM guest state encrypted
     */
    ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey(com.pulumi.azurenative.compute.enums.DiskSecurityTypes.ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey),

    /**
     * Indicates Confidential VM disk with both OS disk and VM guest state encrypted with a platform managed key
     */
    ConfidentialVM_DiskEncryptedWithPlatformKey(com.pulumi.azurenative.compute.enums.DiskSecurityTypes.ConfidentialVM_DiskEncryptedWithPlatformKey),

    /**
     * Indicates Confidential VM disk with both OS disk and VM guest state encrypted with a customer managed key
     */
    ConfidentialVM_DiskEncryptedWithCustomerKey(com.pulumi.azurenative.compute.enums.DiskSecurityTypes.ConfidentialVM_DiskEncryptedWithCustomerKey),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskSecurityTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskSecurityTypes):
            DiskSecurityTypes = DiskSecurityTypes.values().first { it.javaValue == javaType }
    }
}
