@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the storage account type to be used to store the image. This property is not updatable.
 */
public enum class EdgeZoneStorageAccountType(
    public val javaValue: com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType> {
    Standard_LRS(com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType.Standard_LRS),
    Standard_ZRS(com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType.Standard_ZRS),
    StandardSSD_LRS(com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType.StandardSSD_LRS),
    Premium_LRS(com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType.Premium_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.EdgeZoneStorageAccountType):
            EdgeZoneStorageAccountType =
            EdgeZoneStorageAccountType.values().first { it.javaValue == javaType }
    }
}
