@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The sku name.
 */
public enum class SnapshotStorageAccountTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.SnapshotStorageAccountTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.SnapshotStorageAccountTypes> {
    /**
     * Standard HDD locally redundant storage
     */
    Standard_LRS(com.pulumi.azurenative.compute.enums.SnapshotStorageAccountTypes.Standard_LRS),

    /**
     * Premium SSD locally redundant storage
     */
    Premium_LRS(com.pulumi.azurenative.compute.enums.SnapshotStorageAccountTypes.Premium_LRS),

    /**
     * Standard zone redundant storage
     */
    Standard_ZRS(com.pulumi.azurenative.compute.enums.SnapshotStorageAccountTypes.Standard_ZRS),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.SnapshotStorageAccountTypes =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.SnapshotStorageAccountTypes):
            SnapshotStorageAccountTypes =
            SnapshotStorageAccountTypes.values().first { it.javaValue == javaType }
    }
}
