@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.AutomaticRepairsPolicyArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.RepairAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the configuration parameters for automatic repairs on the virtual machine scale set.
 * @property enabled Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
 * @property gracePeriod The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
 * @property repairAction Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace.
 */
public data class AutomaticRepairsPolicyArgs(
    public val enabled: Output<Boolean>? = null,
    public val gracePeriod: Output<String>? = null,
    public val repairAction: Output<Either<String, RepairAction>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.AutomaticRepairsPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.AutomaticRepairsPolicyArgs =
        com.pulumi.azurenative.compute.inputs.AutomaticRepairsPolicyArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .gracePeriod(gracePeriod?.applyValue({ args0 -> args0 }))
            .repairAction(
                repairAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomaticRepairsPolicyArgs].
 */
@PulumiTagMarker
public class AutomaticRepairsPolicyArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var gracePeriod: Output<String>? = null

    private var repairAction: Output<Either<String, RepairAction>>? = null

    /**
     * @param value Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
     */
    @JvmName("xhflgiiknftpepgr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
     */
    @JvmName("chvqqlcnstxqxabr")
    public suspend fun gracePeriod(`value`: Output<String>) {
        this.gracePeriod = value
    }

    /**
     * @param value Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace.
     */
    @JvmName("gdgrxogjsvdvccxl")
    public suspend fun repairAction(`value`: Output<Either<String, RepairAction>>) {
        this.repairAction = value
    }

    /**
     * @param value Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is false.
     */
    @JvmName("xmjajgfawyjykdlh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
     */
    @JvmName("wbmnuiudutnxgncv")
    public suspend fun gracePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gracePeriod = mapped
    }

    /**
     * @param value Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace.
     */
    @JvmName("pphwkcggnvmrahno")
    public suspend fun repairAction(`value`: Either<String, RepairAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repairAction = mapped
    }

    /**
     * @param value Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace.
     */
    @JvmName("fqmfnpdpunttyclf")
    public fun repairAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RepairAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repairAction = mapped
    }

    /**
     * @param value Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace.
     */
    @JvmName("elkmwxtsqmvfrmpw")
    public fun repairAction(`value`: RepairAction) {
        val toBeMapped = Either.ofRight<String, RepairAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repairAction = mapped
    }

    internal fun build(): AutomaticRepairsPolicyArgs = AutomaticRepairsPolicyArgs(
        enabled = enabled,
        gracePeriod = gracePeriod,
        repairAction = repairAction,
    )
}
