@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceOsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the OS profile for the cloud service.
 * @property secrets Specifies set of certificates that should be installed onto the role instances.
 */
public data class CloudServiceOsProfileArgs(
    public val secrets: Output<List<CloudServiceVaultSecretGroupArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceOsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceOsProfileArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceOsProfileArgs.builder()
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudServiceOsProfileArgs].
 */
@PulumiTagMarker
public class CloudServiceOsProfileArgsBuilder internal constructor() {
    private var secrets: Output<List<CloudServiceVaultSecretGroupArgs>>? = null

    /**
     * @param value Specifies set of certificates that should be installed onto the role instances.
     */
    @JvmName("crufbsviswknfxso")
    public suspend fun secrets(`value`: Output<List<CloudServiceVaultSecretGroupArgs>>) {
        this.secrets = value
    }

    @JvmName("enxkxymydnfomtyt")
    public suspend fun secrets(vararg values: Output<CloudServiceVaultSecretGroupArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Specifies set of certificates that should be installed onto the role instances.
     */
    @JvmName("gbfssochpbarqdgh")
    public suspend fun secrets(values: List<Output<CloudServiceVaultSecretGroupArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value Specifies set of certificates that should be installed onto the role instances.
     */
    @JvmName("qsiariwjmhkdbymy")
    public suspend fun secrets(`value`: List<CloudServiceVaultSecretGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument Specifies set of certificates that should be installed onto the role instances.
     */
    @JvmName("movipuwilwugphlp")
    public suspend
    fun secrets(argument: List<suspend CloudServiceVaultSecretGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CloudServiceVaultSecretGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Specifies set of certificates that should be installed onto the role instances.
     */
    @JvmName("meooqphpfrwdkqwu")
    public suspend fun secrets(
        vararg
        argument: suspend CloudServiceVaultSecretGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CloudServiceVaultSecretGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Specifies set of certificates that should be installed onto the role instances.
     */
    @JvmName("rcxqrluujmjrvwdc")
    public suspend fun secrets(argument: suspend CloudServiceVaultSecretGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CloudServiceVaultSecretGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values Specifies set of certificates that should be installed onto the role instances.
     */
    @JvmName("eutvfxnfdwolybfc")
    public suspend fun secrets(vararg values: CloudServiceVaultSecretGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    internal fun build(): CloudServiceOsProfileArgs = CloudServiceOsProfileArgs(
        secrets = secrets,
    )
}
