@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.CloudServiceUpgradeMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cloud service properties
 * @property allowModelOverride (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override the role instance count and vm size specified in the .cscfg and .csdef respectively.
 * The default value is `false`.
 * @property configuration Specifies the XML service configuration (.cscfg) for the cloud service.
 * @property configurationUrl Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
 * This is a write-only property and is not returned in GET calls.
 * @property extensionProfile Describes a cloud service extension profile.
 * @property networkProfile Network Profile for the cloud service.
 * @property osProfile Describes the OS profile for the cloud service.
 * @property packageUrl Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
 * This is a write-only property and is not returned in GET calls.
 * @property roleProfile Describes the role profile for the cloud service.
 * @property startCloudService (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
 * If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
 * @property upgradeMode Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
 * Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
 * If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
 */
public data class CloudServicePropertiesArgs(
    public val allowModelOverride: Output<Boolean>? = null,
    public val configuration: Output<String>? = null,
    public val configurationUrl: Output<String>? = null,
    public val extensionProfile: Output<CloudServiceExtensionProfileArgs>? = null,
    public val networkProfile: Output<CloudServiceNetworkProfileArgs>? = null,
    public val osProfile: Output<CloudServiceOsProfileArgs>? = null,
    public val packageUrl: Output<String>? = null,
    public val roleProfile: Output<CloudServiceRoleProfileArgs>? = null,
    public val startCloudService: Output<Boolean>? = null,
    public val upgradeMode: Output<Either<String, CloudServiceUpgradeMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs =
        com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs.builder()
            .allowModelOverride(allowModelOverride?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0 }))
            .configurationUrl(configurationUrl?.applyValue({ args0 -> args0 }))
            .extensionProfile(extensionProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageUrl(packageUrl?.applyValue({ args0 -> args0 }))
            .roleProfile(roleProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startCloudService(startCloudService?.applyValue({ args0 -> args0 }))
            .upgradeMode(
                upgradeMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudServicePropertiesArgs].
 */
@PulumiTagMarker
public class CloudServicePropertiesArgsBuilder internal constructor() {
    private var allowModelOverride: Output<Boolean>? = null

    private var configuration: Output<String>? = null

    private var configurationUrl: Output<String>? = null

    private var extensionProfile: Output<CloudServiceExtensionProfileArgs>? = null

    private var networkProfile: Output<CloudServiceNetworkProfileArgs>? = null

    private var osProfile: Output<CloudServiceOsProfileArgs>? = null

    private var packageUrl: Output<String>? = null

    private var roleProfile: Output<CloudServiceRoleProfileArgs>? = null

    private var startCloudService: Output<Boolean>? = null

    private var upgradeMode: Output<Either<String, CloudServiceUpgradeMode>>? = null

    /**
     * @param value (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override the role instance count and vm size specified in the .cscfg and .csdef respectively.
     * The default value is `false`.
     */
    @JvmName("ohlhpmtdnqnrvlxk")
    public suspend fun allowModelOverride(`value`: Output<Boolean>) {
        this.allowModelOverride = value
    }

    /**
     * @param value Specifies the XML service configuration (.cscfg) for the cloud service.
     */
    @JvmName("offjlatkpdwcvfkv")
    public suspend fun configuration(`value`: Output<String>) {
        this.configuration = value
    }

    /**
     * @param value Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
     * This is a write-only property and is not returned in GET calls.
     */
    @JvmName("muxkfrxmadxumqui")
    public suspend fun configurationUrl(`value`: Output<String>) {
        this.configurationUrl = value
    }

    /**
     * @param value Describes a cloud service extension profile.
     */
    @JvmName("byqtvujhhpggfykt")
    public suspend fun extensionProfile(`value`: Output<CloudServiceExtensionProfileArgs>) {
        this.extensionProfile = value
    }

    /**
     * @param value Network Profile for the cloud service.
     */
    @JvmName("yfjbbmukqgrpctfg")
    public suspend fun networkProfile(`value`: Output<CloudServiceNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value Describes the OS profile for the cloud service.
     */
    @JvmName("ckjdsybjrnaddtql")
    public suspend fun osProfile(`value`: Output<CloudServiceOsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
     * This is a write-only property and is not returned in GET calls.
     */
    @JvmName("jxyqmhsmasfgcvtl")
    public suspend fun packageUrl(`value`: Output<String>) {
        this.packageUrl = value
    }

    /**
     * @param value Describes the role profile for the cloud service.
     */
    @JvmName("oshvptmplhswpdtm")
    public suspend fun roleProfile(`value`: Output<CloudServiceRoleProfileArgs>) {
        this.roleProfile = value
    }

    /**
     * @param value (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
     * If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
     */
    @JvmName("mciffmdxxcqhuhye")
    public suspend fun startCloudService(`value`: Output<Boolean>) {
        this.startCloudService = value
    }

    /**
     * @param value Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
     * Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
     * If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
     */
    @JvmName("gyoooojhiiggkogg")
    public suspend fun upgradeMode(`value`: Output<Either<String, CloudServiceUpgradeMode>>) {
        this.upgradeMode = value
    }

    /**
     * @param value (Optional) Indicates whether the role sku properties (roleProfile.roles.sku) specified in the model/template should override the role instance count and vm size specified in the .cscfg and .csdef respectively.
     * The default value is `false`.
     */
    @JvmName("frtnricxvqdgloho")
    public suspend fun allowModelOverride(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowModelOverride = mapped
    }

    /**
     * @param value Specifies the XML service configuration (.cscfg) for the cloud service.
     */
    @JvmName("jghfkhltlajrbebx")
    public suspend fun configuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
     * This is a write-only property and is not returned in GET calls.
     */
    @JvmName("whyfdojxhujmyicn")
    public suspend fun configurationUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationUrl = mapped
    }

    /**
     * @param value Describes a cloud service extension profile.
     */
    @JvmName("vhpwllbjuurxerrh")
    public suspend fun extensionProfile(`value`: CloudServiceExtensionProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionProfile = mapped
    }

    /**
     * @param argument Describes a cloud service extension profile.
     */
    @JvmName("ianksxglchisbuwg")
    public suspend
    fun extensionProfile(argument: suspend CloudServiceExtensionProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceExtensionProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extensionProfile = mapped
    }

    /**
     * @param value Network Profile for the cloud service.
     */
    @JvmName("borvmwejpuqphrge")
    public suspend fun networkProfile(`value`: CloudServiceNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Network Profile for the cloud service.
     */
    @JvmName("inpvgtdiveqjbcls")
    public suspend
    fun networkProfile(argument: suspend CloudServiceNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value Describes the OS profile for the cloud service.
     */
    @JvmName("ebfgyxnjuyxmrvjt")
    public suspend fun osProfile(`value`: CloudServiceOsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument Describes the OS profile for the cloud service.
     */
    @JvmName("sjxjovxpphhaecml")
    public suspend fun osProfile(argument: suspend CloudServiceOsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceOsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
     * This is a write-only property and is not returned in GET calls.
     */
    @JvmName("esldlrntvuvghfja")
    public suspend fun packageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageUrl = mapped
    }

    /**
     * @param value Describes the role profile for the cloud service.
     */
    @JvmName("hmnpiomkwyhjgflh")
    public suspend fun roleProfile(`value`: CloudServiceRoleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleProfile = mapped
    }

    /**
     * @param argument Describes the role profile for the cloud service.
     */
    @JvmName("mdqjdxwaqvnnxamw")
    public suspend fun roleProfile(argument: suspend CloudServiceRoleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceRoleProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.roleProfile = mapped
    }

    /**
     * @param value (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
     * If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
     */
    @JvmName("omxkayatydymagfk")
    public suspend fun startCloudService(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startCloudService = mapped
    }

    /**
     * @param value Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
     * Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
     * If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
     */
    @JvmName("pputvmycycwtufkd")
    public suspend fun upgradeMode(`value`: Either<String, CloudServiceUpgradeMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeMode = mapped
    }

    /**
     * @param value Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
     * Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
     * If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
     */
    @JvmName("upvxbjmoxerbojvj")
    public fun upgradeMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudServiceUpgradeMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeMode = mapped
    }

    /**
     * @param value Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
     * Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
     * If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
     */
    @JvmName("pfdkqkvrgeftcslp")
    public fun upgradeMode(`value`: CloudServiceUpgradeMode) {
        val toBeMapped = Either.ofRight<String, CloudServiceUpgradeMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeMode = mapped
    }

    internal fun build(): CloudServicePropertiesArgs = CloudServicePropertiesArgs(
        allowModelOverride = allowModelOverride,
        configuration = configuration,
        configurationUrl = configurationUrl,
        extensionProfile = extensionProfile,
        networkProfile = networkProfile,
        osProfile = osProfile,
        packageUrl = packageUrl,
        roleProfile = roleProfile,
        startCloudService = startCloudService,
        upgradeMode = upgradeMode,
    )
}
