@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DiffDiskOptions
import com.pulumi.azurenative.compute.kotlin.enums.DiffDiskPlacement
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the parameters of ephemeral disk settings that can be specified for operating system disk. **Note:** The ephemeral disk settings can only be specified for managed disk.
 * @property option Specifies the ephemeral disk settings for operating system disk.
 * @property placement Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
 */
public data class DiffDiskSettingsArgs(
    public val option: Output<Either<String, DiffDiskOptions>>? = null,
    public val placement: Output<Either<String, DiffDiskPlacement>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs =
        com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs.builder()
            .option(
                option?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .placement(
                placement?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DiffDiskSettingsArgs].
 */
@PulumiTagMarker
public class DiffDiskSettingsArgsBuilder internal constructor() {
    private var option: Output<Either<String, DiffDiskOptions>>? = null

    private var placement: Output<Either<String, DiffDiskPlacement>>? = null

    /**
     * @param value Specifies the ephemeral disk settings for operating system disk.
     */
    @JvmName("yshsaimweuerlsqu")
    public suspend fun option(`value`: Output<Either<String, DiffDiskOptions>>) {
        this.option = value
    }

    /**
     * @param value Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
     */
    @JvmName("xdsrugmmyhkwjsms")
    public suspend fun placement(`value`: Output<Either<String, DiffDiskPlacement>>) {
        this.placement = value
    }

    /**
     * @param value Specifies the ephemeral disk settings for operating system disk.
     */
    @JvmName("qinmrgdetmhtvdpe")
    public suspend fun option(`value`: Either<String, DiffDiskOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.option = mapped
    }

    /**
     * @param value Specifies the ephemeral disk settings for operating system disk.
     */
    @JvmName("vbsgxvgelvqknepj")
    public fun option(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiffDiskOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.option = mapped
    }

    /**
     * @param value Specifies the ephemeral disk settings for operating system disk.
     */
    @JvmName("tmcjvdcaeaqsggtd")
    public fun option(`value`: DiffDiskOptions) {
        val toBeMapped = Either.ofRight<String, DiffDiskOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.option = mapped
    }

    /**
     * @param value Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
     */
    @JvmName("ltkrusqbhhyenqjf")
    public suspend fun placement(`value`: Either<String, DiffDiskPlacement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placement = mapped
    }

    /**
     * @param value Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
     */
    @JvmName("eovrpimogsnaeyqk")
    public fun placement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiffDiskPlacement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placement = mapped
    }

    /**
     * @param value Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
     */
    @JvmName("suwberkgrrikamia")
    public fun placement(`value`: DiffDiskPlacement) {
        val toBeMapped = Either.ofRight<String, DiffDiskPlacement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placement = mapped
    }

    internal fun build(): DiffDiskSettingsArgs = DiffDiskSettingsArgs(
        option = option,
        placement = placement,
    )
}
