@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DisallowedArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the disallowed disk types.
 * @property diskTypes A list of disk types.
 */
public data class DisallowedArgs(
    public val diskTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DisallowedArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DisallowedArgs =
        com.pulumi.azurenative.compute.inputs.DisallowedArgs.builder()
            .diskTypes(diskTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DisallowedArgs].
 */
@PulumiTagMarker
public class DisallowedArgsBuilder internal constructor() {
    private var diskTypes: Output<List<String>>? = null

    /**
     * @param value A list of disk types.
     */
    @JvmName("xdkdrjnjoouagnwe")
    public suspend fun diskTypes(`value`: Output<List<String>>) {
        this.diskTypes = value
    }

    @JvmName("egpirdpagqlnkhej")
    public suspend fun diskTypes(vararg values: Output<String>) {
        this.diskTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of disk types.
     */
    @JvmName("sjrkcdigivlvukdx")
    public suspend fun diskTypes(values: List<Output<String>>) {
        this.diskTypes = Output.all(values)
    }

    /**
     * @param value A list of disk types.
     */
    @JvmName("mjsmktbbdpyuvoul")
    public suspend fun diskTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskTypes = mapped
    }

    /**
     * @param values A list of disk types.
     */
    @JvmName("dutlpfgheklqswgi")
    public suspend fun diskTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskTypes = mapped
    }

    internal fun build(): DisallowedArgs = DisallowedArgs(
        diskTypes = diskTypes,
    )
}
