@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.EncryptionArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.EncryptionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Encryption at rest settings for disk or snapshot
 * @property diskEncryptionSetId ResourceId of the disk encryption set to use for enabling encryption at rest.
 * @property type The type of key used to encrypt the data of the disk.
 */
public data class EncryptionArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val type: Output<Either<String, EncryptionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.EncryptionArgs =
        com.pulumi.azurenative.compute.inputs.EncryptionArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var type: Output<Either<String, EncryptionType>>? = null

    /**
     * @param value ResourceId of the disk encryption set to use for enabling encryption at rest.
     */
    @JvmName("knnorxvxlamdhvct")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("xvyoqkurfwedtaai")
    public suspend fun type(`value`: Output<Either<String, EncryptionType>>) {
        this.type = value
    }

    /**
     * @param value ResourceId of the disk encryption set to use for enabling encryption at rest.
     */
    @JvmName("lfrtjmsjooccgegg")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("gqrwmoccxhpoksed")
    public suspend fun type(`value`: Either<String, EncryptionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("kgptenjlknuunjuw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of key used to encrypt the data of the disk.
     */
    @JvmName("lrxgpumsodtppihj")
    public fun type(`value`: EncryptionType) {
        val toBeMapped = Either.ofRight<String, EncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        diskEncryptionSetId = diskEncryptionSetId,
        type = type,
    )
}
