@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.EncryptionSettingsCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Encryption settings for disk or snapshot
 * @property enabled Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
 * @property encryptionSettings A collection of encryption settings, one for each disk volume.
 * @property encryptionSettingsVersion Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
 */
public data class EncryptionSettingsCollectionArgs(
    public val enabled: Output<Boolean>,
    public val encryptionSettings: Output<List<EncryptionSettingsElementArgs>>? = null,
    public val encryptionSettingsVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.EncryptionSettingsCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.EncryptionSettingsCollectionArgs =
        com.pulumi.azurenative.compute.inputs.EncryptionSettingsCollectionArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .encryptionSettings(
                encryptionSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .encryptionSettingsVersion(encryptionSettingsVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionSettingsCollectionArgs].
 */
@PulumiTagMarker
public class EncryptionSettingsCollectionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var encryptionSettings: Output<List<EncryptionSettingsElementArgs>>? = null

    private var encryptionSettingsVersion: Output<String>? = null

    /**
     * @param value Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
     */
    @JvmName("imiooikgwksybyyc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A collection of encryption settings, one for each disk volume.
     */
    @JvmName("gyylbljvpoyjqlyy")
    public suspend fun encryptionSettings(`value`: Output<List<EncryptionSettingsElementArgs>>) {
        this.encryptionSettings = value
    }

    @JvmName("ihqhjhyqjmqpqecj")
    public suspend fun encryptionSettings(vararg values: Output<EncryptionSettingsElementArgs>) {
        this.encryptionSettings = Output.all(values.asList())
    }

    /**
     * @param values A collection of encryption settings, one for each disk volume.
     */
    @JvmName("adotuxnuvleibpmg")
    public suspend fun encryptionSettings(values: List<Output<EncryptionSettingsElementArgs>>) {
        this.encryptionSettings = Output.all(values)
    }

    /**
     * @param value Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
     */
    @JvmName("gsahpnjaoqejnspm")
    public suspend fun encryptionSettingsVersion(`value`: Output<String>) {
        this.encryptionSettingsVersion = value
    }

    /**
     * @param value Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
     */
    @JvmName("nrpjfyvgpkgxuddg")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A collection of encryption settings, one for each disk volume.
     */
    @JvmName("mbjbbhuereqjbljn")
    public suspend fun encryptionSettings(`value`: List<EncryptionSettingsElementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettings = mapped
    }

    /**
     * @param argument A collection of encryption settings, one for each disk volume.
     */
    @JvmName("bdgijrwiwdkrdppa")
    public suspend
    fun encryptionSettings(argument: List<suspend EncryptionSettingsElementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EncryptionSettingsElementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionSettings = mapped
    }

    /**
     * @param argument A collection of encryption settings, one for each disk volume.
     */
    @JvmName("sjaqyirfkwclhhbi")
    public suspend fun encryptionSettings(
        vararg
        argument: suspend EncryptionSettingsElementArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EncryptionSettingsElementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.encryptionSettings = mapped
    }

    /**
     * @param argument A collection of encryption settings, one for each disk volume.
     */
    @JvmName("ycoeyfuvwbdblome")
    public suspend
    fun encryptionSettings(argument: suspend EncryptionSettingsElementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EncryptionSettingsElementArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.encryptionSettings = mapped
    }

    /**
     * @param values A collection of encryption settings, one for each disk volume.
     */
    @JvmName("dlkpnbwmieathony")
    public suspend fun encryptionSettings(vararg values: EncryptionSettingsElementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionSettings = mapped
    }

    /**
     * @param value Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
     */
    @JvmName("uihifaqnwvcbfdmu")
    public suspend fun encryptionSettingsVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettingsVersion = mapped
    }

    internal fun build(): EncryptionSettingsCollectionArgs = EncryptionSettingsCollectionArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        encryptionSettings = encryptionSettings,
        encryptionSettingsVersion = encryptionSettingsVersion,
    )
}
