@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryDataDiskImageArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.HostCaching
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * This is the data disk image.
 * @property hostCaching The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
 * @property lun This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
 * @property source The source for the disk image.
 */
public data class GalleryDataDiskImageArgs(
    public val hostCaching: Output<HostCaching>? = null,
    public val lun: Output<Int>,
    public val source: Output<GalleryDiskImageSourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryDataDiskImageArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryDataDiskImageArgs =
        com.pulumi.azurenative.compute.inputs.GalleryDataDiskImageArgs.builder()
            .hostCaching(hostCaching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lun(lun.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GalleryDataDiskImageArgs].
 */
@PulumiTagMarker
public class GalleryDataDiskImageArgsBuilder internal constructor() {
    private var hostCaching: Output<HostCaching>? = null

    private var lun: Output<Int>? = null

    private var source: Output<GalleryDiskImageSourceArgs>? = null

    /**
     * @param value The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
     */
    @JvmName("xsodtkmklckbpiiy")
    public suspend fun hostCaching(`value`: Output<HostCaching>) {
        this.hostCaching = value
    }

    /**
     * @param value This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
     */
    @JvmName("jjtjruhmwbwobdul")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value The source for the disk image.
     */
    @JvmName("ciemjsibayopfplk")
    public suspend fun source(`value`: Output<GalleryDiskImageSourceArgs>) {
        this.source = value
    }

    /**
     * @param value The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
     */
    @JvmName("isaxltsbkfgwtciq")
    public suspend fun hostCaching(`value`: HostCaching?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostCaching = mapped
    }

    /**
     * @param value This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
     */
    @JvmName("petsrtklhhtobrih")
    public suspend fun lun(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value The source for the disk image.
     */
    @JvmName("dynejudrxcsgbpur")
    public suspend fun source(`value`: GalleryDiskImageSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source for the disk image.
     */
    @JvmName("hjacvjwnfcfucanc")
    public suspend fun source(argument: suspend GalleryDiskImageSourceArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryDiskImageSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    internal fun build(): GalleryDataDiskImageArgs = GalleryDataDiskImageArgs(
        hostCaching = hostCaching,
        lun = lun ?: throw PulumiNullFieldException("lun"),
        source = source,
    )
}
