@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryImageVersionPublishingProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.ReplicationMode
import com.pulumi.azurenative.compute.kotlin.enums.StorageAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The publishing profile of a gallery image Version.
 * @property endOfLifeDate The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
 * @property excludeFromLatest If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
 * @property replicaCount The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
 * @property replicationMode Optional parameter which specifies the mode to be used for replication. This property is not updatable.
 * @property storageAccountType Specifies the storage account type to be used to store the image. This property is not updatable.
 * @property targetExtendedLocations The target extended locations where the Image Version is going to be replicated to. This property is updatable.
 * @property targetRegions The target regions where the Image Version is going to be replicated to. This property is updatable.
 */
public data class GalleryImageVersionPublishingProfileArgs(
    public val endOfLifeDate: Output<String>? = null,
    public val excludeFromLatest: Output<Boolean>? = null,
    public val replicaCount: Output<Int>? = null,
    public val replicationMode: Output<Either<String, ReplicationMode>>? = null,
    public val storageAccountType: Output<Either<String, StorageAccountType>>? = null,
    public val targetExtendedLocations: Output<List<GalleryTargetExtendedLocationArgs>>? = null,
    public val targetRegions: Output<List<TargetRegionArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryImageVersionPublishingProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GalleryImageVersionPublishingProfileArgs =
        com.pulumi.azurenative.compute.inputs.GalleryImageVersionPublishingProfileArgs.builder()
            .endOfLifeDate(endOfLifeDate?.applyValue({ args0 -> args0 }))
            .excludeFromLatest(excludeFromLatest?.applyValue({ args0 -> args0 }))
            .replicaCount(replicaCount?.applyValue({ args0 -> args0 }))
            .replicationMode(
                replicationMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .targetExtendedLocations(
                targetExtendedLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetRegions(
                targetRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GalleryImageVersionPublishingProfileArgs].
 */
@PulumiTagMarker
public class GalleryImageVersionPublishingProfileArgsBuilder internal constructor() {
    private var endOfLifeDate: Output<String>? = null

    private var excludeFromLatest: Output<Boolean>? = null

    private var replicaCount: Output<Int>? = null

    private var replicationMode: Output<Either<String, ReplicationMode>>? = null

    private var storageAccountType: Output<Either<String, StorageAccountType>>? = null

    private var targetExtendedLocations: Output<List<GalleryTargetExtendedLocationArgs>>? = null

    private var targetRegions: Output<List<TargetRegionArgs>>? = null

    /**
     * @param value The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("shkwukulnftdiqcu")
    public suspend fun endOfLifeDate(`value`: Output<String>) {
        this.endOfLifeDate = value
    }

    /**
     * @param value If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
     */
    @JvmName("ibupysjixiwkdupd")
    public suspend fun excludeFromLatest(`value`: Output<Boolean>) {
        this.excludeFromLatest = value
    }

    /**
     * @param value The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
     */
    @JvmName("yyiuftgxiinhblta")
    public suspend fun replicaCount(`value`: Output<Int>) {
        this.replicaCount = value
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("shqndjskqbqfptxo")
    public suspend fun replicationMode(`value`: Output<Either<String, ReplicationMode>>) {
        this.replicationMode = value
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("qhvxbkhlwyrglcxd")
    public suspend fun storageAccountType(`value`: Output<Either<String, StorageAccountType>>) {
        this.storageAccountType = value
    }

    /**
     * @param value The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("iqcetvksmmmmwoxj")
    public suspend
    fun targetExtendedLocations(`value`: Output<List<GalleryTargetExtendedLocationArgs>>) {
        this.targetExtendedLocations = value
    }

    @JvmName("vpswayhiqpbgpdpc")
    public suspend fun targetExtendedLocations(
        vararg
        values: Output<GalleryTargetExtendedLocationArgs>,
    ) {
        this.targetExtendedLocations = Output.all(values.asList())
    }

    /**
     * @param values The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("xtolptsmuumvyskf")
    public suspend
    fun targetExtendedLocations(values: List<Output<GalleryTargetExtendedLocationArgs>>) {
        this.targetExtendedLocations = Output.all(values)
    }

    /**
     * @param value The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("kctylbdclskdcdqw")
    public suspend fun targetRegions(`value`: Output<List<TargetRegionArgs>>) {
        this.targetRegions = value
    }

    @JvmName("hdgqvmondikkfugk")
    public suspend fun targetRegions(vararg values: Output<TargetRegionArgs>) {
        this.targetRegions = Output.all(values.asList())
    }

    /**
     * @param values The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("alipyeoeeqdfbktl")
    public suspend fun targetRegions(values: List<Output<TargetRegionArgs>>) {
        this.targetRegions = Output.all(values)
    }

    /**
     * @param value The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("hmdpyphlqvytguvj")
    public suspend fun endOfLifeDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endOfLifeDate = mapped
    }

    /**
     * @param value If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
     */
    @JvmName("mnrxjtaijrovpahj")
    public suspend fun excludeFromLatest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeFromLatest = mapped
    }

    /**
     * @param value The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
     */
    @JvmName("utsbtmwmrqdwklrd")
    public suspend fun replicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCount = mapped
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("tgfqfoohlirhwgej")
    public suspend fun replicationMode(`value`: Either<String, ReplicationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("toblaqlsrmhscbba")
    public fun replicationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("mhrrymditevvyyxt")
    public fun replicationMode(`value`: ReplicationMode) {
        val toBeMapped = Either.ofRight<String, ReplicationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("uxvtrwiricrgwudq")
    public suspend fun storageAccountType(`value`: Either<String, StorageAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("beaojltmqmiejelb")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("klgpcopxdrpulqad")
    public fun storageAccountType(`value`: StorageAccountType) {
        val toBeMapped = Either.ofRight<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("qgkvyfvocsmjpcly")
    public suspend fun targetExtendedLocations(`value`: List<GalleryTargetExtendedLocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetExtendedLocations = mapped
    }

    /**
     * @param argument The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("njurtbcdqxorwiff")
    public suspend
    fun targetExtendedLocations(argument: List<suspend GalleryTargetExtendedLocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryTargetExtendedLocationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetExtendedLocations = mapped
    }

    /**
     * @param argument The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("dftwldvntmsogmrl")
    public suspend fun targetExtendedLocations(
        vararg
        argument: suspend GalleryTargetExtendedLocationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GalleryTargetExtendedLocationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetExtendedLocations = mapped
    }

    /**
     * @param argument The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("vogbyjmjjisqslir")
    public suspend
    fun targetExtendedLocations(argument: suspend GalleryTargetExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GalleryTargetExtendedLocationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetExtendedLocations = mapped
    }

    /**
     * @param values The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("oxaunfwpcabbrlyw")
    public suspend fun targetExtendedLocations(vararg values: GalleryTargetExtendedLocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetExtendedLocations = mapped
    }

    /**
     * @param value The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("kjkvkwqssyrmyrfq")
    public suspend fun targetRegions(`value`: List<TargetRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("scweaicngiyllhdt")
    public suspend fun targetRegions(argument: List<suspend TargetRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("buvaplwnsvurcyhp")
    public suspend fun targetRegions(vararg argument: suspend TargetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("extskvyguijigsto")
    public suspend fun targetRegions(argument: suspend TargetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetRegionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param values The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("nnmgtbsjftrdqncx")
    public suspend fun targetRegions(vararg values: TargetRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRegions = mapped
    }

    internal fun build(): GalleryImageVersionPublishingProfileArgs =
        GalleryImageVersionPublishingProfileArgs(
            endOfLifeDate = endOfLifeDate,
            excludeFromLatest = excludeFromLatest,
            replicaCount = replicaCount,
            replicationMode = replicationMode,
            storageAccountType = storageAccountType,
            targetExtendedLocations = targetExtendedLocations,
            targetRegions = targetRegions,
        )
}
