@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryImageVersionSafetyProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This is the safety profile of the Gallery Image Version.
 * @property allowDeletionOfReplicatedLocations Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
 */
public data class GalleryImageVersionSafetyProfileArgs(
    public val allowDeletionOfReplicatedLocations: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryImageVersionSafetyProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryImageVersionSafetyProfileArgs =
        com.pulumi.azurenative.compute.inputs.GalleryImageVersionSafetyProfileArgs.builder()
            .allowDeletionOfReplicatedLocations(
                allowDeletionOfReplicatedLocations?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [GalleryImageVersionSafetyProfileArgs].
 */
@PulumiTagMarker
public class GalleryImageVersionSafetyProfileArgsBuilder internal constructor() {
    private var allowDeletionOfReplicatedLocations: Output<Boolean>? = null

    /**
     * @param value Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
     */
    @JvmName("jowlthryxixebddl")
    public suspend fun allowDeletionOfReplicatedLocations(`value`: Output<Boolean>) {
        this.allowDeletionOfReplicatedLocations = value
    }

    /**
     * @param value Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
     */
    @JvmName("sgoiiggqecapleqm")
    public suspend fun allowDeletionOfReplicatedLocations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowDeletionOfReplicatedLocations = mapped
    }

    internal fun build(): GalleryImageVersionSafetyProfileArgs = GalleryImageVersionSafetyProfileArgs(
        allowDeletionOfReplicatedLocations = allowDeletionOfReplicatedLocations,
    )
}
