@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryOSDiskImageArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.HostCaching
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * This is the OS disk image.
 * @property hostCaching The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
 * @property source The source for the disk image.
 */
public data class GalleryOSDiskImageArgs(
    public val hostCaching: Output<HostCaching>? = null,
    public val source: Output<GalleryDiskImageSourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryOSDiskImageArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryOSDiskImageArgs =
        com.pulumi.azurenative.compute.inputs.GalleryOSDiskImageArgs.builder()
            .hostCaching(hostCaching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GalleryOSDiskImageArgs].
 */
@PulumiTagMarker
public class GalleryOSDiskImageArgsBuilder internal constructor() {
    private var hostCaching: Output<HostCaching>? = null

    private var source: Output<GalleryDiskImageSourceArgs>? = null

    /**
     * @param value The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
     */
    @JvmName("ioqtqnmgfmlasfas")
    public suspend fun hostCaching(`value`: Output<HostCaching>) {
        this.hostCaching = value
    }

    /**
     * @param value The source for the disk image.
     */
    @JvmName("ewxerphrwblxbsab")
    public suspend fun source(`value`: Output<GalleryDiskImageSourceArgs>) {
        this.source = value
    }

    /**
     * @param value The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
     */
    @JvmName("tglyikpxgjivkjnx")
    public suspend fun hostCaching(`value`: HostCaching?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostCaching = mapped
    }

    /**
     * @param value The source for the disk image.
     */
    @JvmName("ggiccrajsntbhvbv")
    public suspend fun source(`value`: GalleryDiskImageSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source for the disk image.
     */
    @JvmName("xiqmrtpbpanvuqmu")
    public suspend fun source(argument: suspend GalleryDiskImageSourceArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryDiskImageSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    internal fun build(): GalleryOSDiskImageArgs = GalleryOSDiskImageArgs(
        hostCaching = hostCaching,
        source = source,
    )
}
