@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetDiskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diskName The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDiskPlainArgs(
    public val diskName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetDiskPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetDiskPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetDiskPlainArgs.builder()
            .diskName(diskName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskPlainArgs].
 */
@PulumiTagMarker
public class GetDiskPlainArgsBuilder internal constructor() {
    private var diskName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     */
    @JvmName("mlgiqmwxiohmavwu")
    public suspend fun diskName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diskName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ywhwavwfidfanvyk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDiskPlainArgs = GetDiskPlainArgs(
        diskName = diskName ?: throw PulumiNullFieldException("diskName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
