@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetGalleryApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property galleryApplicationName The name of the gallery Application Definition to be retrieved.
 * @property galleryName The name of the Shared Application Gallery from which the Application Definitions are to be retrieved.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetGalleryApplicationPlainArgs(
    public val galleryApplicationName: String,
    public val galleryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetGalleryApplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetGalleryApplicationPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetGalleryApplicationPlainArgs.builder()
            .galleryApplicationName(galleryApplicationName.let({ args0 -> args0 }))
            .galleryName(galleryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetGalleryApplicationPlainArgsBuilder internal constructor() {
    private var galleryApplicationName: String? = null

    private var galleryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the gallery Application Definition to be retrieved.
     */
    @JvmName("awvidcylgpmrapmu")
    public suspend fun galleryApplicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryApplicationName = mapped
    }

    /**
     * @param value The name of the Shared Application Gallery from which the Application Definitions are to be retrieved.
     */
    @JvmName("hjelciuqqsmiledx")
    public suspend fun galleryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lwsajhqthawggkep")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGalleryApplicationPlainArgs = GetGalleryApplicationPlainArgs(
        galleryApplicationName = galleryApplicationName ?: throw
            PulumiNullFieldException("galleryApplicationName"),
        galleryName = galleryName ?: throw PulumiNullFieldException("galleryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
