@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetLogAnalyticExportThrottledRequestsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blobContainerSasUri SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
 * @property fromTime From time of the query
 * @property groupByClientApplicationId Group query result by Client Application ID.
 * @property groupByOperationName Group query result by Operation Name.
 * @property groupByResourceName Group query result by Resource Name.
 * @property groupByThrottlePolicy Group query result by Throttle Policy applied.
 * @property groupByUserAgent Group query result by User Agent.
 * @property location The location upon which virtual-machine-sizes is queried.
 * @property toTime To time of the query
 */
public data class GetLogAnalyticExportThrottledRequestsPlainArgs(
    public val blobContainerSasUri: String,
    public val fromTime: String,
    public val groupByClientApplicationId: Boolean? = null,
    public val groupByOperationName: Boolean? = null,
    public val groupByResourceName: Boolean? = null,
    public val groupByThrottlePolicy: Boolean? = null,
    public val groupByUserAgent: Boolean? = null,
    public val location: String,
    public val toTime: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetLogAnalyticExportThrottledRequestsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GetLogAnalyticExportThrottledRequestsPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetLogAnalyticExportThrottledRequestsPlainArgs.builder()
            .blobContainerSasUri(blobContainerSasUri.let({ args0 -> args0 }))
            .fromTime(fromTime.let({ args0 -> args0 }))
            .groupByClientApplicationId(groupByClientApplicationId?.let({ args0 -> args0 }))
            .groupByOperationName(groupByOperationName?.let({ args0 -> args0 }))
            .groupByResourceName(groupByResourceName?.let({ args0 -> args0 }))
            .groupByThrottlePolicy(groupByThrottlePolicy?.let({ args0 -> args0 }))
            .groupByUserAgent(groupByUserAgent?.let({ args0 -> args0 }))
            .location(location.let({ args0 -> args0 }))
            .toTime(toTime.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogAnalyticExportThrottledRequestsPlainArgs].
 */
@PulumiTagMarker
public class GetLogAnalyticExportThrottledRequestsPlainArgsBuilder internal constructor() {
    private var blobContainerSasUri: String? = null

    private var fromTime: String? = null

    private var groupByClientApplicationId: Boolean? = null

    private var groupByOperationName: Boolean? = null

    private var groupByResourceName: Boolean? = null

    private var groupByThrottlePolicy: Boolean? = null

    private var groupByUserAgent: Boolean? = null

    private var location: String? = null

    private var toTime: String? = null

    /**
     * @param value SAS Uri of the logging blob container to which LogAnalytics Api writes output logs to.
     */
    @JvmName("qbpbwqydetkgylnf")
    public suspend fun blobContainerSasUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blobContainerSasUri = mapped
    }

    /**
     * @param value From time of the query
     */
    @JvmName("bfhnyettxuxacimc")
    public suspend fun fromTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fromTime = mapped
    }

    /**
     * @param value Group query result by Client Application ID.
     */
    @JvmName("tsfqulxfytqqwojf")
    public suspend fun groupByClientApplicationId(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupByClientApplicationId = mapped
    }

    /**
     * @param value Group query result by Operation Name.
     */
    @JvmName("qrvlsbpirvbxbhun")
    public suspend fun groupByOperationName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupByOperationName = mapped
    }

    /**
     * @param value Group query result by Resource Name.
     */
    @JvmName("ufeytsagaixrpsbq")
    public suspend fun groupByResourceName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupByResourceName = mapped
    }

    /**
     * @param value Group query result by Throttle Policy applied.
     */
    @JvmName("txyvrvkqywqpbxsn")
    public suspend fun groupByThrottlePolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupByThrottlePolicy = mapped
    }

    /**
     * @param value Group query result by User Agent.
     */
    @JvmName("snlfelqtwrxofche")
    public suspend fun groupByUserAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupByUserAgent = mapped
    }

    /**
     * @param value The location upon which virtual-machine-sizes is queried.
     */
    @JvmName("ekupkcsloymmhbth")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value To time of the query
     */
    @JvmName("somhspgohilwvvor")
    public suspend fun toTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.toTime = mapped
    }

    internal fun build(): GetLogAnalyticExportThrottledRequestsPlainArgs =
        GetLogAnalyticExportThrottledRequestsPlainArgs(
            blobContainerSasUri = blobContainerSasUri ?: throw PulumiNullFieldException("blobContainerSasUri"),
            fromTime = fromTime ?: throw PulumiNullFieldException("fromTime"),
            groupByClientApplicationId = groupByClientApplicationId,
            groupByOperationName = groupByOperationName,
            groupByResourceName = groupByResourceName,
            groupByThrottlePolicy = groupByThrottlePolicy,
            groupByUserAgent = groupByUserAgent,
            location = location ?: throw PulumiNullFieldException("location"),
            toTime = toTime ?: throw PulumiNullFieldException("toTime"),
        )
}
