@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetProximityPlacementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
 * @property proximityPlacementGroupName The name of the proximity placement group.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetProximityPlacementGroupPlainArgs(
    public val includeColocationStatus: String? = null,
    public val proximityPlacementGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetProximityPlacementGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetProximityPlacementGroupPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetProximityPlacementGroupPlainArgs.builder()
            .includeColocationStatus(includeColocationStatus?.let({ args0 -> args0 }))
            .proximityPlacementGroupName(proximityPlacementGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProximityPlacementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetProximityPlacementGroupPlainArgsBuilder internal constructor() {
    private var includeColocationStatus: String? = null

    private var proximityPlacementGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value includeColocationStatus=true enables fetching the colocation status of all the resources in the proximity placement group.
     */
    @JvmName("frxiftaopnvdxbsa")
    public suspend fun includeColocationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeColocationStatus = mapped
    }

    /**
     * @param value The name of the proximity placement group.
     */
    @JvmName("alrpmygnmdwapthb")
    public suspend fun proximityPlacementGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.proximityPlacementGroupName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("biiygpxrodnfspfs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProximityPlacementGroupPlainArgs = GetProximityPlacementGroupPlainArgs(
        includeColocationStatus = includeColocationStatus,
        proximityPlacementGroupName = proximityPlacementGroupName ?: throw
            PulumiNullFieldException("proximityPlacementGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
