@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetSnapshotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80 characters.
 */
public data class GetSnapshotPlainArgs(
    public val resourceGroupName: String,
    public val snapshotName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetSnapshotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetSnapshotPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetSnapshotPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .snapshotName(snapshotName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnapshotPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var snapshotName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tponurikbcaslorr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the snapshot that is being created. The name can't be changed after the snapshot is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80 characters.
     */
    @JvmName("hbpgudifddmqpcwd")
    public suspend fun snapshotName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.snapshotName = mapped
    }

    internal fun build(): GetSnapshotPlainArgs = GetSnapshotPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        snapshotName = snapshotName ?: throw PulumiNullFieldException("snapshotName"),
    )
}
