@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation. 'UserData' retrieves the UserData property of the VM scale set that was provided by the user during the VM scale set Create/Update operation
 * @property resourceGroupName The name of the resource group.
 * @property vmScaleSetName The name of the VM scale set.
 */
public data class GetVirtualMachineScaleSetPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val vmScaleSetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineScaleSetPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmScaleSetName(vmScaleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineScaleSetPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineScaleSetPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var vmScaleSetName: String? = null

    /**
     * @param value The expand expression to apply on the operation. 'UserData' retrieves the UserData property of the VM scale set that was provided by the user during the VM scale set Create/Update operation
     */
    @JvmName("evromilpabwdywyw")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tuicmsejhgcoonqk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VM scale set.
     */
    @JvmName("dpmdcrlumakmdxop")
    public suspend fun vmScaleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmScaleSetName = mapped
    }

    internal fun build(): GetVirtualMachineScaleSetPlainArgs = GetVirtualMachineScaleSetPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmScaleSetName = vmScaleSetName ?: throw PulumiNullFieldException("vmScaleSetName"),
    )
}
