@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The source image used for creating the disk.
 * @property communityGalleryImageId A relative uri containing a community Azure Compute Gallery image reference.
 * @property id A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
 * @property lun If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
 * @property sharedGalleryImageId A relative uri containing a direct shared Azure Compute Gallery image reference.
 */
public data class ImageDiskReferenceArgs(
    public val communityGalleryImageId: Output<String>? = null,
    public val id: Output<String>? = null,
    public val lun: Output<Int>? = null,
    public val sharedGalleryImageId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs =
        com.pulumi.azurenative.compute.inputs.ImageDiskReferenceArgs.builder()
            .communityGalleryImageId(communityGalleryImageId?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .lun(lun?.applyValue({ args0 -> args0 }))
            .sharedGalleryImageId(sharedGalleryImageId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageDiskReferenceArgs].
 */
@PulumiTagMarker
public class ImageDiskReferenceArgsBuilder internal constructor() {
    private var communityGalleryImageId: Output<String>? = null

    private var id: Output<String>? = null

    private var lun: Output<Int>? = null

    private var sharedGalleryImageId: Output<String>? = null

    /**
     * @param value A relative uri containing a community Azure Compute Gallery image reference.
     */
    @JvmName("fmlwvfyawmpmqjvk")
    public suspend fun communityGalleryImageId(`value`: Output<String>) {
        this.communityGalleryImageId = value
    }

    /**
     * @param value A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
     */
    @JvmName("ftofjfpydkgjcwvy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
     */
    @JvmName("podtlsbyhnmbwfqt")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value A relative uri containing a direct shared Azure Compute Gallery image reference.
     */
    @JvmName("qtshhyscblbbhxny")
    public suspend fun sharedGalleryImageId(`value`: Output<String>) {
        this.sharedGalleryImageId = value
    }

    /**
     * @param value A relative uri containing a community Azure Compute Gallery image reference.
     */
    @JvmName("ewexywxnscqligkc")
    public suspend fun communityGalleryImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communityGalleryImageId = mapped
    }

    /**
     * @param value A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
     */
    @JvmName("sxveqylfoqotuojv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
     */
    @JvmName("uschbfclkcskrfru")
    public suspend fun lun(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value A relative uri containing a direct shared Azure Compute Gallery image reference.
     */
    @JvmName("tfiuroogedmuyfil")
    public suspend fun sharedGalleryImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedGalleryImageId = mapped
    }

    internal fun build(): ImageDiskReferenceArgs = ImageDiskReferenceArgs(
        communityGalleryImageId = communityGalleryImageId,
        id = id,
        lun = lun,
        sharedGalleryImageId = sharedGalleryImageId,
    )
}
