@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ImagePurchasePlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the gallery image definition purchase plan. This is used by marketplace images.
 * @property name The plan ID.
 * @property product The product ID.
 * @property publisher The publisher ID.
 */
public data class ImagePurchasePlanArgs(
    public val name: Output<String>? = null,
    public val product: Output<String>? = null,
    public val publisher: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ImagePurchasePlanArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ImagePurchasePlanArgs =
        com.pulumi.azurenative.compute.inputs.ImagePurchasePlanArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImagePurchasePlanArgs].
 */
@PulumiTagMarker
public class ImagePurchasePlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value The plan ID.
     */
    @JvmName("urqdcgkleberylrp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The product ID.
     */
    @JvmName("qhionhdkgcrykkmf")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("fhqnjvhfahfbgnbm")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The plan ID.
     */
    @JvmName("drpgcgxbuqqushaj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The product ID.
     */
    @JvmName("lgincvsvioparqve")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("pqwowrgtjjcuduvy")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): ImagePurchasePlanArgs = ImagePurchasePlanArgs(
        name = name,
        product = product,
        publisher = publisher,
    )
}
