@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the properties of the load balancer configuration.
 * @property frontendIpConfigurations Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
 */
public data class LoadBalancerConfigurationPropertiesArgs(
    public val frontendIpConfigurations: Output<List<LoadBalancerFrontendIpConfigurationArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationPropertiesArgs =
        com.pulumi.azurenative.compute.inputs.LoadBalancerConfigurationPropertiesArgs.builder()
            .frontendIpConfigurations(
                frontendIpConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class LoadBalancerConfigurationPropertiesArgsBuilder internal constructor() {
    private var frontendIpConfigurations: Output<List<LoadBalancerFrontendIpConfigurationArgs>>? =
        null

    /**
     * @param value Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
     */
    @JvmName("jmqpvoklkvpnyvnt")
    public suspend
    fun frontendIpConfigurations(`value`: Output<List<LoadBalancerFrontendIpConfigurationArgs>>) {
        this.frontendIpConfigurations = value
    }

    @JvmName("cwppknnbynphmkuo")
    public suspend fun frontendIpConfigurations(
        vararg
        values: Output<LoadBalancerFrontendIpConfigurationArgs>,
    ) {
        this.frontendIpConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
     */
    @JvmName("wgqqbaqvbrivceuw")
    public suspend
    fun frontendIpConfigurations(values: List<Output<LoadBalancerFrontendIpConfigurationArgs>>) {
        this.frontendIpConfigurations = Output.all(values)
    }

    /**
     * @param value Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
     */
    @JvmName("wxgdrkjivekbnpjs")
    public suspend
    fun frontendIpConfigurations(`value`: List<LoadBalancerFrontendIpConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIpConfigurations = mapped
    }

    /**
     * @param argument Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
     */
    @JvmName("qvoqpujendvhkcyt")
    public suspend
    fun frontendIpConfigurations(argument: List<suspend LoadBalancerFrontendIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerFrontendIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIpConfigurations = mapped
    }

    /**
     * @param argument Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
     */
    @JvmName("wcrnkeymopnisscr")
    public suspend fun frontendIpConfigurations(
        vararg
        argument: suspend LoadBalancerFrontendIpConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerFrontendIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIpConfigurations = mapped
    }

    /**
     * @param argument Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
     */
    @JvmName("xpixfmgevsaqimlq")
    public suspend
    fun frontendIpConfigurations(argument: suspend LoadBalancerFrontendIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerFrontendIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.frontendIpConfigurations = mapped
    }

    /**
     * @param values Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
     */
    @JvmName("welavhshvnmbdfsk")
    public suspend fun frontendIpConfigurations(
        vararg
        values: LoadBalancerFrontendIpConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIpConfigurations = mapped
    }

    internal fun build(): LoadBalancerConfigurationPropertiesArgs =
        LoadBalancerConfigurationPropertiesArgs(
            frontendIpConfigurations = frontendIpConfigurations ?: throw
                PulumiNullFieldException("frontendIpConfigurations"),
        )
}
