@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the frontend IP to be used for the load balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must have exactly one frontend IP configuration.
 * @property name The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
 * @property properties Properties of load balancer frontend ip configuration.
 */
public data class LoadBalancerFrontendIpConfigurationArgs(
    public val name: Output<String>,
    public val properties: Output<LoadBalancerFrontendIpConfigurationPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.LoadBalancerFrontendIpConfigurationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LoadBalancerFrontendIpConfigurationArgs].
 */
@PulumiTagMarker
public class LoadBalancerFrontendIpConfigurationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties: Output<LoadBalancerFrontendIpConfigurationPropertiesArgs>? = null

    /**
     * @param value The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("cmqsanbokeyatrbu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Properties of load balancer frontend ip configuration.
     */
    @JvmName("badkqcuvxljskmbt")
    public suspend
    fun properties(`value`: Output<LoadBalancerFrontendIpConfigurationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("kpwycjwymrukqpks")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Properties of load balancer frontend ip configuration.
     */
    @JvmName("krmutmnudpbwhcoh")
    public suspend fun properties(`value`: LoadBalancerFrontendIpConfigurationPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of load balancer frontend ip configuration.
     */
    @JvmName("krbldrmyfxbhopjk")
    public suspend
    fun properties(argument: suspend LoadBalancerFrontendIpConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerFrontendIpConfigurationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): LoadBalancerFrontendIpConfigurationArgs =
        LoadBalancerFrontendIpConfigurationArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            properties = properties ?: throw PulumiNullFieldException("properties"),
        )
}
