@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.NetworkInterfaceReferenceArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DeleteOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a network interface reference.
 * @property deleteOption Specify what happens to the network interface when the VM is deleted
 * @property id Resource Id
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 */
public data class NetworkInterfaceReferenceArgs(
    public val deleteOption: Output<Either<String, DeleteOptions>>? = null,
    public val id: Output<String>? = null,
    public val primary: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.NetworkInterfaceReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.NetworkInterfaceReferenceArgs =
        com.pulumi.azurenative.compute.inputs.NetworkInterfaceReferenceArgs.builder()
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceReferenceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceReferenceArgsBuilder internal constructor() {
    private var deleteOption: Output<Either<String, DeleteOptions>>? = null

    private var id: Output<String>? = null

    private var primary: Output<Boolean>? = null

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("yhnwcfsjgggxtfwq")
    public suspend fun deleteOption(`value`: Output<Either<String, DeleteOptions>>) {
        this.deleteOption = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("wrsyprmdtvaicilg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("inlvbuagkwliytbr")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("dtxuabowwmxyqemt")
    public suspend fun deleteOption(`value`: Either<String, DeleteOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("yusrwbgqknojswdh")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("qwuncidulucwxsfq")
    public fun deleteOption(`value`: DeleteOptions) {
        val toBeMapped = Either.ofRight<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Resource Id
     */
    @JvmName("ydqevgqmnetrucnr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("hgymjxcrqashxvvu")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    internal fun build(): NetworkInterfaceReferenceArgs = NetworkInterfaceReferenceArgs(
        deleteOption = deleteOption,
        id = id,
        primary = primary,
    )
}
