@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.NetworkApiVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the network interfaces or the networking configuration of the virtual machine.
 * @property networkApiVersion specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
 * @property networkInterfaceConfigurations Specifies the networking configurations that will be used to create the virtual machine networking resources.
 * @property networkInterfaces Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
 */
public data class NetworkProfileArgs(
    public val networkApiVersion: Output<Either<String, NetworkApiVersion>>? = null,
    public val networkInterfaceConfigurations:
    Output<List<VirtualMachineNetworkInterfaceConfigurationArgs>>? = null,
    public val networkInterfaces: Output<List<NetworkInterfaceReferenceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.compute.inputs.NetworkProfileArgs.builder()
            .networkApiVersion(
                networkApiVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkInterfaceConfigurations(
                networkInterfaceConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var networkApiVersion: Output<Either<String, NetworkApiVersion>>? = null

    private var networkInterfaceConfigurations:
        Output<List<VirtualMachineNetworkInterfaceConfigurationArgs>>? = null

    private var networkInterfaces: Output<List<NetworkInterfaceReferenceArgs>>? = null

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
     */
    @JvmName("ipiopexqpbldmouf")
    public suspend fun networkApiVersion(`value`: Output<Either<String, NetworkApiVersion>>) {
        this.networkApiVersion = value
    }

    /**
     * @param value Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    @JvmName("wmeystktlqakpsos")
    public suspend
    fun networkInterfaceConfigurations(`value`: Output<List<VirtualMachineNetworkInterfaceConfigurationArgs>>) {
        this.networkInterfaceConfigurations = value
    }

    @JvmName("jpyowncfnuijcxex")
    public suspend fun networkInterfaceConfigurations(
        vararg
        values: Output<VirtualMachineNetworkInterfaceConfigurationArgs>,
    ) {
        this.networkInterfaceConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    @JvmName("nagbwpsbvffigmvd")
    public suspend
    fun networkInterfaceConfigurations(values: List<Output<VirtualMachineNetworkInterfaceConfigurationArgs>>) {
        this.networkInterfaceConfigurations = Output.all(values)
    }

    /**
     * @param value Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    @JvmName("hofxxqeftujuoqjr")
    public suspend fun networkInterfaces(`value`: Output<List<NetworkInterfaceReferenceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("pasihxevvghwrrdi")
    public suspend fun networkInterfaces(vararg values: Output<NetworkInterfaceReferenceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    @JvmName("dhrhowmijtfoumbu")
    public suspend fun networkInterfaces(values: List<Output<NetworkInterfaceReferenceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
     */
    @JvmName("mxxpjfnowymejhdf")
    public suspend fun networkApiVersion(`value`: Either<String, NetworkApiVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkApiVersion = mapped
    }

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
     */
    @JvmName("upjaooivbxpsnlic")
    public fun networkApiVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkApiVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkApiVersion = mapped
    }

    /**
     * @param value specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations
     */
    @JvmName("cqwcavtjopxhrghx")
    public fun networkApiVersion(`value`: NetworkApiVersion) {
        val toBeMapped = Either.ofRight<String, NetworkApiVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkApiVersion = mapped
    }

    /**
     * @param value Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    @JvmName("jipnlllkxbrpvmja")
    public suspend
    fun networkInterfaceConfigurations(`value`: List<VirtualMachineNetworkInterfaceConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    @JvmName("yhtefelrqktqcpbf")
    public suspend
    fun networkInterfaceConfigurations(argument: List<suspend VirtualMachineNetworkInterfaceConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineNetworkInterfaceConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    @JvmName("rtjebflpavbfwhmd")
    public suspend fun networkInterfaceConfigurations(
        vararg
        argument: suspend VirtualMachineNetworkInterfaceConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineNetworkInterfaceConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    @JvmName("onpxcslmjnwmason")
    public suspend
    fun networkInterfaceConfigurations(argument: suspend VirtualMachineNetworkInterfaceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineNetworkInterfaceConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param values Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    @JvmName("iejniewoalsysnqt")
    public suspend fun networkInterfaceConfigurations(
        vararg
        values: VirtualMachineNetworkInterfaceConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param value Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    @JvmName("ryohbiatjvdvseuc")
    public suspend fun networkInterfaces(`value`: List<NetworkInterfaceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    @JvmName("vasarnemubpeclur")
    public suspend
    fun networkInterfaces(argument: List<suspend NetworkInterfaceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    @JvmName("kbfadtymvawybuay")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend NetworkInterfaceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkInterfaceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    @JvmName("kghddpbymkasssnc")
    public suspend
    fun networkInterfaces(argument: suspend NetworkInterfaceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkInterfaceReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    @JvmName("ojogseadmipqagki")
    public suspend fun networkInterfaces(vararg values: NetworkInterfaceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        networkApiVersion = networkApiVersion,
        networkInterfaceConfigurations = networkInterfaceConfigurations,
        networkInterfaces = networkInterfaces,
    )
}
