@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.PublicIPAddressSkuArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.PublicIPAddressSkuName
import com.pulumi.azurenative.compute.kotlin.enums.PublicIPAddressSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
 * @property name Specify public IP sku name
 * @property tier Specify public IP sku tier
 */
public data class PublicIPAddressSkuArgs(
    public val name: Output<Either<String, PublicIPAddressSkuName>>? = null,
    public val tier: Output<Either<String, PublicIPAddressSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.PublicIPAddressSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.PublicIPAddressSkuArgs =
        com.pulumi.azurenative.compute.inputs.PublicIPAddressSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PublicIPAddressSkuArgs].
 */
@PulumiTagMarker
public class PublicIPAddressSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, PublicIPAddressSkuName>>? = null

    private var tier: Output<Either<String, PublicIPAddressSkuTier>>? = null

    /**
     * @param value Specify public IP sku name
     */
    @JvmName("jdioefjpyfojyxxg")
    public suspend fun name(`value`: Output<Either<String, PublicIPAddressSkuName>>) {
        this.name = value
    }

    /**
     * @param value Specify public IP sku tier
     */
    @JvmName("dauvfsrugigryfhl")
    public suspend fun tier(`value`: Output<Either<String, PublicIPAddressSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Specify public IP sku name
     */
    @JvmName("deeoaukrplvlcsbe")
    public suspend fun name(`value`: Either<String, PublicIPAddressSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specify public IP sku name
     */
    @JvmName("tyxeklrwjdilxohx")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPAddressSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specify public IP sku name
     */
    @JvmName("rdipinknpjqtiyup")
    public fun name(`value`: PublicIPAddressSkuName) {
        val toBeMapped = Either.ofRight<String, PublicIPAddressSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specify public IP sku tier
     */
    @JvmName("uvmifnmcywpvvfwu")
    public suspend fun tier(`value`: Either<String, PublicIPAddressSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Specify public IP sku tier
     */
    @JvmName("lnyxfreuomsxdirl")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPAddressSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Specify public IP sku tier
     */
    @JvmName("femmdpsfjlbpxrho")
    public fun tier(`value`: PublicIPAddressSkuTier) {
        val toBeMapped = Either.ofRight<String, PublicIPAddressSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): PublicIPAddressSkuArgs = PublicIPAddressSkuArgs(
        name = name,
        tier = tier,
    )
}
