@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.SecurityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the Security profile settings for the virtual machine or virtual machine scale set.
 * @property encryptionAtHost This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. The default behavior is: The Encryption at host will be disabled unless this property is set to true for the resource.
 * @property securityType Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.
 * @property uefiSettings Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.
 */
public data class SecurityProfileArgs(
    public val encryptionAtHost: Output<Boolean>? = null,
    public val securityType: Output<Either<String, SecurityTypes>>? = null,
    public val uefiSettings: Output<UefiSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.SecurityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.SecurityProfileArgs =
        com.pulumi.azurenative.compute.inputs.SecurityProfileArgs.builder()
            .encryptionAtHost(encryptionAtHost?.applyValue({ args0 -> args0 }))
            .securityType(
                securityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .uefiSettings(uefiSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SecurityProfileArgs].
 */
@PulumiTagMarker
public class SecurityProfileArgsBuilder internal constructor() {
    private var encryptionAtHost: Output<Boolean>? = null

    private var securityType: Output<Either<String, SecurityTypes>>? = null

    private var uefiSettings: Output<UefiSettingsArgs>? = null

    /**
     * @param value This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. The default behavior is: The Encryption at host will be disabled unless this property is set to true for the resource.
     */
    @JvmName("lvobrwddijsvrryr")
    public suspend fun encryptionAtHost(`value`: Output<Boolean>) {
        this.encryptionAtHost = value
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.
     */
    @JvmName("efjmwdbvvmpfmnpm")
    public suspend fun securityType(`value`: Output<Either<String, SecurityTypes>>) {
        this.securityType = value
    }

    /**
     * @param value Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.
     */
    @JvmName("canbjmfbaktfpsuu")
    public suspend fun uefiSettings(`value`: Output<UefiSettingsArgs>) {
        this.uefiSettings = value
    }

    /**
     * @param value This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. The default behavior is: The Encryption at host will be disabled unless this property is set to true for the resource.
     */
    @JvmName("wcymfodrhsmdmcsk")
    public suspend fun encryptionAtHost(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.
     */
    @JvmName("sipdjkxiqbteoecd")
    public suspend fun securityType(`value`: Either<String, SecurityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.
     */
    @JvmName("ytvmcvhyytuddsuk")
    public fun securityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.
     */
    @JvmName("atlbfjxynmrrokbf")
    public fun securityType(`value`: SecurityTypes) {
        val toBeMapped = Either.ofRight<String, SecurityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.
     */
    @JvmName("imcimjullbqauxvk")
    public suspend fun uefiSettings(`value`: UefiSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uefiSettings = mapped
    }

    /**
     * @param argument Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.
     */
    @JvmName("ndeemydjapuulgdu")
    public suspend fun uefiSettings(argument: suspend UefiSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UefiSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.uefiSettings = mapped
    }

    internal fun build(): SecurityProfileArgs = SecurityProfileArgs(
        encryptionAtHost = encryptionAtHost,
        securityType = securityType,
        uefiSettings = uefiSettings,
    )
}
