@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.TargetRegionArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.StorageAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the target region information.
 * @property encryption Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
 * @property excludeFromLatest Contains the flag setting to hide an image when users specify version='latest'
 * @property name The name of the region.
 * @property regionalReplicaCount The number of replicas of the Image Version to be created per region. This property is updatable.
 * @property storageAccountType Specifies the storage account type to be used to store the image. This property is not updatable.
 */
public data class TargetRegionArgs(
    public val encryption: Output<EncryptionImagesArgs>? = null,
    public val excludeFromLatest: Output<Boolean>? = null,
    public val name: Output<String>,
    public val regionalReplicaCount: Output<Int>? = null,
    public val storageAccountType: Output<Either<String, StorageAccountType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.TargetRegionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.TargetRegionArgs =
        com.pulumi.azurenative.compute.inputs.TargetRegionArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .excludeFromLatest(excludeFromLatest?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .regionalReplicaCount(regionalReplicaCount?.applyValue({ args0 -> args0 }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [TargetRegionArgs].
 */
@PulumiTagMarker
public class TargetRegionArgsBuilder internal constructor() {
    private var encryption: Output<EncryptionImagesArgs>? = null

    private var excludeFromLatest: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var regionalReplicaCount: Output<Int>? = null

    private var storageAccountType: Output<Either<String, StorageAccountType>>? = null

    /**
     * @param value Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
     */
    @JvmName("istjygwdwdwvqifs")
    public suspend fun encryption(`value`: Output<EncryptionImagesArgs>) {
        this.encryption = value
    }

    /**
     * @param value Contains the flag setting to hide an image when users specify version='latest'
     */
    @JvmName("buhsoxfekrkmshfp")
    public suspend fun excludeFromLatest(`value`: Output<Boolean>) {
        this.excludeFromLatest = value
    }

    /**
     * @param value The name of the region.
     */
    @JvmName("plpwriyifurykvem")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of replicas of the Image Version to be created per region. This property is updatable.
     */
    @JvmName("jrvgaaddsnhouqmf")
    public suspend fun regionalReplicaCount(`value`: Output<Int>) {
        this.regionalReplicaCount = value
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("eoniawlhjrsotnem")
    public suspend fun storageAccountType(`value`: Output<Either<String, StorageAccountType>>) {
        this.storageAccountType = value
    }

    /**
     * @param value Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
     */
    @JvmName("cpounqdwkaxsxfpg")
    public suspend fun encryption(`value`: EncryptionImagesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
     */
    @JvmName("lanyukpxbrfbhxtd")
    public suspend fun encryption(argument: suspend EncryptionImagesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionImagesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Contains the flag setting to hide an image when users specify version='latest'
     */
    @JvmName("pgqgvfrxtsqvmsqp")
    public suspend fun excludeFromLatest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeFromLatest = mapped
    }

    /**
     * @param value The name of the region.
     */
    @JvmName("ppywrkwrvophrvvb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of replicas of the Image Version to be created per region. This property is updatable.
     */
    @JvmName("oaaolrwwwmekjvgp")
    public suspend fun regionalReplicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalReplicaCount = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("ngmheyigvccjepfp")
    public suspend fun storageAccountType(`value`: Either<String, StorageAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("xjpplmbmulshpcse")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("lqxssvblkfydultp")
    public fun storageAccountType(`value`: StorageAccountType) {
        val toBeMapped = Either.ofRight<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    internal fun build(): TargetRegionArgs = TargetRegionArgs(
        encryption = encryption,
        excludeFromLatest = excludeFromLatest,
        name = name ?: throw PulumiNullFieldException("name"),
        regionalReplicaCount = regionalReplicaCount,
        storageAccountType = storageAccountType,
    )
}
