@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.
 * @property secureBootEnabled Specifies whether secure boot should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
 * @property vTpmEnabled Specifies whether vTPM should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
 */
public data class UefiSettingsArgs(
    public val secureBootEnabled: Output<Boolean>? = null,
    public val vTpmEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.UefiSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.UefiSettingsArgs =
        com.pulumi.azurenative.compute.inputs.UefiSettingsArgs.builder()
            .secureBootEnabled(secureBootEnabled?.applyValue({ args0 -> args0 }))
            .vTpmEnabled(vTpmEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UefiSettingsArgs].
 */
@PulumiTagMarker
public class UefiSettingsArgsBuilder internal constructor() {
    private var secureBootEnabled: Output<Boolean>? = null

    private var vTpmEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether secure boot should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
     */
    @JvmName("mqkpyjckjtfnexjo")
    public suspend fun secureBootEnabled(`value`: Output<Boolean>) {
        this.secureBootEnabled = value
    }

    /**
     * @param value Specifies whether vTPM should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
     */
    @JvmName("bmrjiywuwkvhopuo")
    public suspend fun vTpmEnabled(`value`: Output<Boolean>) {
        this.vTpmEnabled = value
    }

    /**
     * @param value Specifies whether secure boot should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
     */
    @JvmName("hgglxfgfmuosoawn")
    public suspend fun secureBootEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureBootEnabled = mapped
    }

    /**
     * @param value Specifies whether vTPM should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
     */
    @JvmName("jecgdewvooltgmxn")
    public suspend fun vTpmEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vTpmEnabled = mapped
    }

    internal fun build(): UefiSettingsArgs = UefiSettingsArgs(
        secureBootEnabled = secureBootEnabled,
        vTpmEnabled = vTpmEnabled,
    )
}
