@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies VM Size Property settings on the virtual machine.
 * @property vCPUsAvailable Specifies the number of vCPUs available for the VM. When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available for that VM size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list).
 * @property vCPUsPerCore Specifies the vCPU to physical core ratio. When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the VM Size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list). **Setting this property to 1 also means that hyper-threading is disabled.**
 */
public data class VMSizePropertiesArgs(
    public val vCPUsAvailable: Output<Int>? = null,
    public val vCPUsPerCore: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs =
        com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs.builder()
            .vCPUsAvailable(vCPUsAvailable?.applyValue({ args0 -> args0 }))
            .vCPUsPerCore(vCPUsPerCore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMSizePropertiesArgs].
 */
@PulumiTagMarker
public class VMSizePropertiesArgsBuilder internal constructor() {
    private var vCPUsAvailable: Output<Int>? = null

    private var vCPUsPerCore: Output<Int>? = null

    /**
     * @param value Specifies the number of vCPUs available for the VM. When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available for that VM size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list).
     */
    @JvmName("rugnjuglarobegrg")
    public suspend fun vCPUsAvailable(`value`: Output<Int>) {
        this.vCPUsAvailable = value
    }

    /**
     * @param value Specifies the vCPU to physical core ratio. When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the VM Size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list). **Setting this property to 1 also means that hyper-threading is disabled.**
     */
    @JvmName("hsbxxvialmofaoqt")
    public suspend fun vCPUsPerCore(`value`: Output<Int>) {
        this.vCPUsPerCore = value
    }

    /**
     * @param value Specifies the number of vCPUs available for the VM. When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available for that VM size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list).
     */
    @JvmName("mckuujjjayjovwto")
    public suspend fun vCPUsAvailable(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCPUsAvailable = mapped
    }

    /**
     * @param value Specifies the vCPU to physical core ratio. When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the VM Size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list). **Setting this property to 1 also means that hyper-threading is disabled.**
     */
    @JvmName("xhimoflauldqwqhr")
    public suspend fun vCPUsPerCore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCPUsPerCore = mapped
    }

    internal fun build(): VMSizePropertiesArgs = VMSizePropertiesArgs(
        vCPUsAvailable = vCPUsAvailable,
        vCPUsPerCore = vCPUsPerCore,
    )
}
