@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceConfigurationArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DeleteOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine network interface configurations.
 * @property deleteOption Specify what happens to the network interface when the VM is deleted
 * @property disableTcpStateTracking Specifies whether the network interface is disabled for tcp state tracking.
 * @property dnsSettings The dns settings to be applied on the network interfaces.
 * @property dscpConfiguration
 * @property enableAcceleratedNetworking Specifies whether the network interface is accelerated networking-enabled.
 * @property enableFpga Specifies whether the network interface is FPGA networking-enabled.
 * @property enableIPForwarding Whether IP forwarding enabled on this NIC.
 * @property ipConfigurations Specifies the IP configurations of the network interface.
 * @property name The network interface configuration name.
 * @property networkSecurityGroup The network security group.
 * @property primary Specifies the primary network interface in case the virtual machine has more than 1 network interface.
 */
public data class VirtualMachineNetworkInterfaceConfigurationArgs(
    public val deleteOption: Output<Either<String, DeleteOptions>>? = null,
    public val disableTcpStateTracking: Output<Boolean>? = null,
    public val dnsSettings: Output<VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs>? =
        null,
    public val dscpConfiguration: Output<SubResourceArgs>? = null,
    public val enableAcceleratedNetworking: Output<Boolean>? = null,
    public val enableFpga: Output<Boolean>? = null,
    public val enableIPForwarding: Output<Boolean>? = null,
    public val ipConfigurations: Output<List<VirtualMachineNetworkInterfaceIPConfigurationArgs>>,
    public val name: Output<String>,
    public val networkSecurityGroup: Output<SubResourceArgs>? = null,
    public val primary: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineNetworkInterfaceConfigurationArgs.builder()
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disableTcpStateTracking(disableTcpStateTracking?.applyValue({ args0 -> args0 }))
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dscpConfiguration(dscpConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableAcceleratedNetworking(enableAcceleratedNetworking?.applyValue({ args0 -> args0 }))
            .enableFpga(enableFpga?.applyValue({ args0 -> args0 }))
            .enableIPForwarding(enableIPForwarding?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .networkSecurityGroup(
                networkSecurityGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .primary(primary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineNetworkInterfaceConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineNetworkInterfaceConfigurationArgsBuilder internal constructor() {
    private var deleteOption: Output<Either<String, DeleteOptions>>? = null

    private var disableTcpStateTracking: Output<Boolean>? = null

    private var dnsSettings: Output<VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs>? =
        null

    private var dscpConfiguration: Output<SubResourceArgs>? = null

    private var enableAcceleratedNetworking: Output<Boolean>? = null

    private var enableFpga: Output<Boolean>? = null

    private var enableIPForwarding: Output<Boolean>? = null

    private var ipConfigurations: Output<List<VirtualMachineNetworkInterfaceIPConfigurationArgs>>? =
        null

    private var name: Output<String>? = null

    private var networkSecurityGroup: Output<SubResourceArgs>? = null

    private var primary: Output<Boolean>? = null

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("rmqsvsxlblkgoefy")
    public suspend fun deleteOption(`value`: Output<Either<String, DeleteOptions>>) {
        this.deleteOption = value
    }

    /**
     * @param value Specifies whether the network interface is disabled for tcp state tracking.
     */
    @JvmName("bgyvobycdodsyour")
    public suspend fun disableTcpStateTracking(`value`: Output<Boolean>) {
        this.disableTcpStateTracking = value
    }

    /**
     * @param value The dns settings to be applied on the network interfaces.
     */
    @JvmName("numngtxebqkymqfs")
    public suspend
    fun dnsSettings(`value`: Output<VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value
     */
    @JvmName("kwcjlhmpipbhefkf")
    public suspend fun dscpConfiguration(`value`: Output<SubResourceArgs>) {
        this.dscpConfiguration = value
    }

    /**
     * @param value Specifies whether the network interface is accelerated networking-enabled.
     */
    @JvmName("eyohiqvfkqkcvikq")
    public suspend fun enableAcceleratedNetworking(`value`: Output<Boolean>) {
        this.enableAcceleratedNetworking = value
    }

    /**
     * @param value Specifies whether the network interface is FPGA networking-enabled.
     */
    @JvmName("muqlgvwcdgrqehhk")
    public suspend fun enableFpga(`value`: Output<Boolean>) {
        this.enableFpga = value
    }

    /**
     * @param value Whether IP forwarding enabled on this NIC.
     */
    @JvmName("vrswmngtavfyfnko")
    public suspend fun enableIPForwarding(`value`: Output<Boolean>) {
        this.enableIPForwarding = value
    }

    /**
     * @param value Specifies the IP configurations of the network interface.
     */
    @JvmName("emavbodqluyvocwe")
    public suspend
    fun ipConfigurations(`value`: Output<List<VirtualMachineNetworkInterfaceIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("idvsiruihpfkcamh")
    public suspend fun ipConfigurations(
        vararg
        values: Output<VirtualMachineNetworkInterfaceIPConfigurationArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Specifies the IP configurations of the network interface.
     */
    @JvmName("yiabhvhndpvsnqvc")
    public suspend
    fun ipConfigurations(values: List<Output<VirtualMachineNetworkInterfaceIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The network interface configuration name.
     */
    @JvmName("yfuyklaghsrunrof")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network security group.
     */
    @JvmName("bdqaygnatfmrxvrq")
    public suspend fun networkSecurityGroup(`value`: Output<SubResourceArgs>) {
        this.networkSecurityGroup = value
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("vpxygqqiudeebnwx")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("yxvshfmqxsilfsgx")
    public suspend fun deleteOption(`value`: Either<String, DeleteOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("tcyqjucpssjsfbhi")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the network interface when the VM is deleted
     */
    @JvmName("fxtqatsrsfaidgis")
    public fun deleteOption(`value`: DeleteOptions) {
        val toBeMapped = Either.ofRight<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specifies whether the network interface is disabled for tcp state tracking.
     */
    @JvmName("rlxtmacirgmjdgql")
    public suspend fun disableTcpStateTracking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableTcpStateTracking = mapped
    }

    /**
     * @param value The dns settings to be applied on the network interfaces.
     */
    @JvmName("epgqmfyjnojhuqnn")
    public suspend
    fun dnsSettings(`value`: VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument The dns settings to be applied on the network interfaces.
     */
    @JvmName("xmtyxbtyfnqtdfdh")
    public suspend
    fun dnsSettings(argument: suspend VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualMachineNetworkInterfaceDnsSettingsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("otndletrkbodqllj")
    public suspend fun dscpConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dscpConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bvjyocwhitesqmwg")
    public suspend fun dscpConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dscpConfiguration = mapped
    }

    /**
     * @param value Specifies whether the network interface is accelerated networking-enabled.
     */
    @JvmName("gdxjctbqcfpvvncp")
    public suspend fun enableAcceleratedNetworking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceleratedNetworking = mapped
    }

    /**
     * @param value Specifies whether the network interface is FPGA networking-enabled.
     */
    @JvmName("tgvhxvekmvrtasls")
    public suspend fun enableFpga(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFpga = mapped
    }

    /**
     * @param value Whether IP forwarding enabled on this NIC.
     */
    @JvmName("uddmquqvwhofwvls")
    public suspend fun enableIPForwarding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIPForwarding = mapped
    }

    /**
     * @param value Specifies the IP configurations of the network interface.
     */
    @JvmName("pkqfompparvnxebc")
    public suspend
    fun ipConfigurations(`value`: List<VirtualMachineNetworkInterfaceIPConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Specifies the IP configurations of the network interface.
     */
    @JvmName("pcswogvldsrwdaac")
    public suspend
    fun ipConfigurations(argument: List<suspend VirtualMachineNetworkInterfaceIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineNetworkInterfaceIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Specifies the IP configurations of the network interface.
     */
    @JvmName("vofyqrbqupvxgfbb")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend VirtualMachineNetworkInterfaceIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineNetworkInterfaceIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Specifies the IP configurations of the network interface.
     */
    @JvmName("oeknrwbrvuqpqecn")
    public suspend
    fun ipConfigurations(argument: suspend VirtualMachineNetworkInterfaceIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineNetworkInterfaceIPConfigurationArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values Specifies the IP configurations of the network interface.
     */
    @JvmName("jxfoxetnoedjjdtw")
    public suspend fun ipConfigurations(
        vararg
        values: VirtualMachineNetworkInterfaceIPConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The network interface configuration name.
     */
    @JvmName("foqviaqjelccnhgy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network security group.
     */
    @JvmName("pwoopcubkgeelqwa")
    public suspend fun networkSecurityGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroup = mapped
    }

    /**
     * @param argument The network security group.
     */
    @JvmName("eoaqygdymuyppgsg")
    public suspend fun networkSecurityGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSecurityGroup = mapped
    }

    /**
     * @param value Specifies the primary network interface in case the virtual machine has more than 1 network interface.
     */
    @JvmName("jvavgeexplgdpvrd")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    internal fun build(): VirtualMachineNetworkInterfaceConfigurationArgs =
        VirtualMachineNetworkInterfaceConfigurationArgs(
            deleteOption = deleteOption,
            disableTcpStateTracking = disableTcpStateTracking,
            dnsSettings = dnsSettings,
            dscpConfiguration = dscpConfiguration,
            enableAcceleratedNetworking = enableAcceleratedNetworking,
            enableFpga = enableFpga,
            enableIPForwarding = enableIPForwarding,
            ipConfigurations = ipConfigurations ?: throw PulumiNullFieldException("ipConfigurations"),
            name = name ?: throw PulumiNullFieldException("name"),
            networkSecurityGroup = networkSecurityGroup,
            primary = primary,
        )
}
