@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a virtual machines network configuration's DNS settings.
 * @property domainNameLabel The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
 */
public data class VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs(
    public val domainNameLabel: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs.builder()
            .domainNameLabel(domainNameLabel.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachinePublicIPAddressDnsSettingsConfigurationArgsBuilder internal constructor() {
    private var domainNameLabel: Output<String>? = null

    /**
     * @param value The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
     */
    @JvmName("dvdjmtvuftjrprmv")
    public suspend fun domainNameLabel(`value`: Output<String>) {
        this.domainNameLabel = value
    }

    /**
     * @param value The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
     */
    @JvmName("xjgeuumoowwgrvuh")
    public suspend fun domainNameLabel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNameLabel = mapped
    }

    internal fun build(): VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs =
        VirtualMachinePublicIPAddressDnsSettingsConfigurationArgs(
            domainNameLabel = domainNameLabel ?: throw PulumiNullFieldException("domainNameLabel"),
        )
}
