@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetHardwareProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the hardware settings for the virtual machine scale set.
 * @property vmSizeProperties Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
 */
public data class VirtualMachineScaleSetHardwareProfileArgs(
    public val vmSizeProperties: Output<VMSizePropertiesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetHardwareProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetHardwareProfileArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetHardwareProfileArgs.builder()
            .vmSizeProperties(
                vmSizeProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineScaleSetHardwareProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetHardwareProfileArgsBuilder internal constructor() {
    private var vmSizeProperties: Output<VMSizePropertiesArgs>? = null

    /**
     * @param value Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    @JvmName("mwdqfrofqjsbqypx")
    public suspend fun vmSizeProperties(`value`: Output<VMSizePropertiesArgs>) {
        this.vmSizeProperties = value
    }

    /**
     * @param value Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    @JvmName("mhqgurtkdiqvdksj")
    public suspend fun vmSizeProperties(`value`: VMSizePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSizeProperties = mapped
    }

    /**
     * @param argument Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.
     */
    @JvmName("hdgcysqemfpwsojo")
    public suspend fun vmSizeProperties(argument: suspend VMSizePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VMSizePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmSizeProperties = mapped
    }

    internal fun build(): VirtualMachineScaleSetHardwareProfileArgs =
        VirtualMachineScaleSetHardwareProfileArgs(
            vmSizeProperties = vmSizeProperties,
        )
}
