@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a virtual machine scale set VM network profile.
 * @property networkInterfaceConfigurations The list of network configurations.
 */
public data class VirtualMachineScaleSetVMNetworkProfileConfigurationArgs(
    public val networkInterfaceConfigurations:
    Output<List<VirtualMachineScaleSetNetworkConfigurationArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.VirtualMachineScaleSetVMNetworkProfileConfigurationArgs.builder()
            .networkInterfaceConfigurations(
                networkInterfaceConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineScaleSetVMNetworkProfileConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineScaleSetVMNetworkProfileConfigurationArgsBuilder internal constructor() {
    private var networkInterfaceConfigurations:
        Output<List<VirtualMachineScaleSetNetworkConfigurationArgs>>? = null

    /**
     * @param value The list of network configurations.
     */
    @JvmName("xdgdihngcfgmpwdv")
    public suspend
    fun networkInterfaceConfigurations(`value`: Output<List<VirtualMachineScaleSetNetworkConfigurationArgs>>) {
        this.networkInterfaceConfigurations = value
    }

    @JvmName("ecjlieegkcoyypgd")
    public suspend fun networkInterfaceConfigurations(
        vararg
        values: Output<VirtualMachineScaleSetNetworkConfigurationArgs>,
    ) {
        this.networkInterfaceConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The list of network configurations.
     */
    @JvmName("bewaxyeuhvgqywbw")
    public suspend
    fun networkInterfaceConfigurations(values: List<Output<VirtualMachineScaleSetNetworkConfigurationArgs>>) {
        this.networkInterfaceConfigurations = Output.all(values)
    }

    /**
     * @param value The list of network configurations.
     */
    @JvmName("foogxsitgflykcoi")
    public suspend
    fun networkInterfaceConfigurations(`value`: List<VirtualMachineScaleSetNetworkConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument The list of network configurations.
     */
    @JvmName("atvnylpepyoqqqyl")
    public suspend
    fun networkInterfaceConfigurations(argument: List<suspend VirtualMachineScaleSetNetworkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetNetworkConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument The list of network configurations.
     */
    @JvmName("iysqjhpfwdeoqfeo")
    public suspend fun networkInterfaceConfigurations(
        vararg
        argument: suspend VirtualMachineScaleSetNetworkConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineScaleSetNetworkConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param argument The list of network configurations.
     */
    @JvmName("gjhksvgvxmmidpig")
    public suspend
    fun networkInterfaceConfigurations(argument: suspend VirtualMachineScaleSetNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineScaleSetNetworkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaceConfigurations = mapped
    }

    /**
     * @param values The list of network configurations.
     */
    @JvmName("yhngpbyjplabejwr")
    public suspend fun networkInterfaceConfigurations(
        vararg
        values: VirtualMachineScaleSetNetworkConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaceConfigurations = mapped
    }

    internal fun build(): VirtualMachineScaleSetVMNetworkProfileConfigurationArgs =
        VirtualMachineScaleSetVMNetworkProfileConfigurationArgs(
            networkInterfaceConfigurations = networkInterfaceConfigurations,
        )
}
