@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.WinRMConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes Windows Remote Management configuration of the VM
 * @property listeners The list of Windows Remote Management listeners
 */
public data class WinRMConfigurationArgs(
    public val listeners: Output<List<WinRMListenerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.WinRMConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.WinRMConfigurationArgs =
        com.pulumi.azurenative.compute.inputs.WinRMConfigurationArgs.builder()
            .listeners(
                listeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WinRMConfigurationArgs].
 */
@PulumiTagMarker
public class WinRMConfigurationArgsBuilder internal constructor() {
    private var listeners: Output<List<WinRMListenerArgs>>? = null

    /**
     * @param value The list of Windows Remote Management listeners
     */
    @JvmName("jjfynncvmsmulqfi")
    public suspend fun listeners(`value`: Output<List<WinRMListenerArgs>>) {
        this.listeners = value
    }

    @JvmName("bbljkykiulijtqna")
    public suspend fun listeners(vararg values: Output<WinRMListenerArgs>) {
        this.listeners = Output.all(values.asList())
    }

    /**
     * @param values The list of Windows Remote Management listeners
     */
    @JvmName("rtopxfoealexndsw")
    public suspend fun listeners(values: List<Output<WinRMListenerArgs>>) {
        this.listeners = Output.all(values)
    }

    /**
     * @param value The list of Windows Remote Management listeners
     */
    @JvmName("mxwabrmthjpbjugl")
    public suspend fun listeners(`value`: List<WinRMListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param argument The list of Windows Remote Management listeners
     */
    @JvmName("ahtdqgxqmurngrwa")
    public suspend fun listeners(argument: List<suspend WinRMListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WinRMListenerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument The list of Windows Remote Management listeners
     */
    @JvmName("awikvvduxottwvcq")
    public suspend fun listeners(vararg argument: suspend WinRMListenerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WinRMListenerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument The list of Windows Remote Management listeners
     */
    @JvmName("ncdcjottufkrqmvw")
    public suspend fun listeners(argument: suspend WinRMListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WinRMListenerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param values The list of Windows Remote Management listeners
     */
    @JvmName("cstomhgmwtfvcskt")
    public suspend fun listeners(vararg values: WinRMListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    internal fun build(): WinRMConfigurationArgs = WinRMConfigurationArgs(
        listeners = listeners,
    )
}
