@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
 * @property componentName The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
 * @property content Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
 * @property passName The pass name. Currently, the only allowable value is OobeSystem.
 * @property settingName Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
 */
public data class AdditionalUnattendContentResponse(
    public val componentName: String? = null,
    public val content: String? = null,
    public val passName: String? = null,
    public val settingName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.compute.outputs.AdditionalUnattendContentResponse):
            AdditionalUnattendContentResponse = AdditionalUnattendContentResponse(
            componentName = javaType.componentName().map({ args0 -> args0 }).orElse(null),
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            passName = javaType.passName().map({ args0 -> args0 }).orElse(null),
            settingName = javaType.settingName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
